/*
 * This file is part of mapper
 *
 * Copyright (C) 2006-2007 John Costigan.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef _MAPPER_UTILS_H
#define _MAPPER_UTILS_H

#include "config.h"
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include <stddef.h>
#include <locale.h>
#include <math.h>
#include <errno.h>
#include <sys/wait.h>
#include <glib/gstdio.h>
#include <glib/gi18n.h>
#include <gtk/gtk.h>
#include <curl/multi.h>
#include <gconf/gconf-client.h>

#include "mapper.h"
#include "path.h"
#include "mapper-types.h"
#include "gpsdata.h"

/****************************************************************************
 * BELOW: DEFINES ***********************************************************
 ****************************************************************************/

/* #define DEBUG */

#ifndef DEBUG
#define printf(...)
#endif

/* Set the below if to determine whether to get verbose output. */
#if 1
#define vprintf printf
#else
#define vprintf(...)
#endif

#define SQR(s) ((s)*(s))

#define BUFFER_SIZE (2048)

#define MACRO_CURL_PROXY(C) { \
if (_http_proxy_host) { \
	curl_easy_setopt(C, CURLOPT_PROXY, _http_proxy_host);\
	if (_http_proxy_port>0) \
		curl_easy_setopt(C, CURLOPT_PROXYPORT, _http_proxy_port); \
} \
}

#define MACRO_CURL_EASY_INIT(C) { \
	C = curl_easy_init(); \
	curl_easy_setopt(C, CURLOPT_NOPROGRESS, 1); \
	curl_easy_setopt(C, CURLOPT_FOLLOWLOCATION, 1); \
	curl_easy_setopt(C, CURLOPT_MAXREDIRS, 20); \
	curl_easy_setopt(C, CURLOPT_FAILONERROR, 1); \
	curl_easy_setopt(C, CURLOPT_USERAGENT, \
            "Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.0.4) Gecko/20060701 Firefox/1.5.0.4"); \
	curl_easy_setopt(C, CURLOPT_TIMEOUT, 30); \
	curl_easy_setopt(C, CURLOPT_CONNECTTIMEOUT, 10); \
}

#ifdef WITH_HILDON
#define MACRO_BANNER_SHOW_INFO(A, S) { \
    gchar *my_macro_buffer = g_markup_printf_escaped("<span size='%s'>%s</span>", \
            INFO_FONT_TEXT[_info_font_size], (S)); \
    hildon_banner_show_information_with_markup(A, NULL, my_macro_buffer); \
    g_free(my_macro_buffer); \
}
#else
#define MACRO_BANNER_SHOW_INFO(A, S) { hildon_banner_show_information(A, NULL, S); }
#endif

void sound_noise(void);
void keep_display_on(MapperApp *app);

#endif
