#ifndef _MAPPER_TRACK_H
#define _MAPPER_TRACK_H

#include <glib.h>
#include <sqlite3.h>
#include "filter.h"

Path *_track;

#define TRACK_SQL_SELECT_TRACKS "select id,name,slat,slon,elat,elon,len,sdate,edate from tracks order by sdate"
#define TRACK_SQL_INSERT_TRACK "insert into tracks (id,name,sloc,sdate) values (?,?,?,?)"
#define TRACK_SQL_INSERT_TRACK_POINT "insert into trackpoints (tid,dt,lat,lon,alt,hdop,vdop,pdop,sat,fix) values (?,?,?,?,?,?,?,?,?,?)"
#define TRACK_SQL_SELECT_TRACK_POINTS "select tid,dt,lat,lon,alt,hdop,vdop,pdop,sat,fix from trackpoints where tid=? order by dt"

struct {
	sqlite3_stmt *insert_track;
	sqlite3_stmt *select_tracks;
	sqlite3_stmt *select_latest_track;
	sqlite3_stmt *delete_track;

	sqlite3_stmt *insert_track_point;
	sqlite3_stmt *select_track_points;
	sqlite3_stmt *delete_track_points;
} track_sql;

void track_init(void);
void track_deinit(void);

gboolean track_add(GpsData *gps);
gboolean track_insert_break(void);
gboolean track_insert_mark(void);
gboolean track_save(void);
gboolean track_open(void);
void track_clear(void);

void track_show_distance_from_first();
void track_show_distance_from_last();
void track_show_distance_from(Point * point);

#endif
