/*
 * This file is part of mapper
 *
 * Copyright (C) 2007 Kaj-Michael Lang
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <config.h>

#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include <stddef.h>
#include <errno.h>
#include <sys/wait.h>
#include <glib/gstdio.h>
#include <gtk/gtk.h>
#include <fcntl.h>

#include <sys/socket.h>
#include <bluetooth/bluetooth.h>
#include <bluetooth/hci.h>
#include <bluetooth/hci_lib.h>
#include <bluetooth/rfcomm.h>

#include "gps-scan.h"

static gboolean 
gps_scan_bluetooth_idle_sync(GpsScanInfo *scan_info)
{
gint devid, num_rsp;
GtkTreeIter iter;
inquiry_info *ii=NULL;

devid=hci_get_route(NULL);

ii=(inquiry_info *)malloc(255 * sizeof(inquiry_info));
num_rsp=hci_inquiry(devid, 4, 255, NULL, &ii, IREQ_CACHE_FLUSH);

if (num_rsp < 0) {
	gtk_widget_destroy(scan_info->banner);
} else if (num_rsp == 0) {
	gtk_widget_destroy(scan_info->banner);
} else {
	gint i;
	gint sock=hci_open_dev(devid);

	gtk_list_store_clear(scan_info->store);
	for (i=0; i<num_rsp; i++) {
		gchar addr[19]={ 0 };
		gchar name[256]={ 0 };

		ba2str(&ii[i].bdaddr, addr);
		memset(name, 0, sizeof(name));
		if (hci_read_remote_name(sock, &ii[i].bdaddr, sizeof(name), name, 0))
			strcpy(name, "Unknown");

		gtk_list_store_append(scan_info->store, &iter);
		gtk_list_store_set(scan_info->store, &iter,
			0, g_strdup(addr),
			1, g_strdup(name), -1);
	}
	close(sock);
}
free(ii);
scan_info->sid=0;
return FALSE;
}

GpsScanResult 
gps_scan_start_search(GpsScanInfo *scan_info)
{
scan_info->sid=g_idle_add((GSourceFunc)gps_scan_bluetooth_idle_sync, scan_info);
return GPS_SCAN_OK;
}

gboolean
gps_scan_stop_search(GpsScanInfo *scan_info)
{
return TRUE;
}
