#ifndef _MAPPER_CB_H
#define _MAPPER_CB_H

#include <config.h>

#include <gtk/gtk.h>

gboolean window_cb_key_press(GtkWidget * widget, GdkEventKey * event);
gboolean window_cb_key_release(GtkWidget * widget, GdkEventKey * event);

gboolean sat_panel_expose(GtkWidget * widget, GdkEventExpose * event);

/* Callbacks for the "Route" submenu. */
gboolean menu_cb_route_download(GtkAction * action);
gboolean menu_cb_route_open(GtkAction * action);
gboolean menu_cb_route_save(GtkAction * action);
gboolean menu_cb_route_distnext(GtkAction * action);
gboolean menu_cb_route_distlast(GtkAction * action);
gboolean menu_cb_route_reset(GtkAction * action);
gboolean menu_cb_route_clear(GtkAction * action);

/* Callbacks for the "Track" submenu. */
gboolean menu_cb_track_open(GtkAction * action);
gboolean menu_cb_track_save(GtkAction * action);
gboolean menu_cb_track_insert_break(GtkAction * action);
gboolean menu_cb_track_insert_mark(GtkAction * action);
gboolean menu_cb_track_distlast(GtkAction * action);
gboolean menu_cb_track_distfirst(GtkAction * action);
gboolean menu_cb_track_clear(GtkAction * action);
gboolean menu_cb_track_filter(GtkAction * action);

/* Callbacks for the "Maps" submenu. */
gboolean menu_cb_maps_select(GtkAction * action, gpointer new_repo);
gboolean menu_cb_mapman(GtkAction * action);
gboolean menu_cb_auto_download(GtkAction * action);

/* Callbacks for the "View" submenu. */
gboolean cb_zoom_auto(GtkAction * action);
gboolean cb_zoom_base(GtkAction * action);
gboolean cb_zoomin(GtkAction * action);
gboolean cb_zoomout(GtkAction * action);
gboolean cb_fullscreen(GtkAction * action);
gboolean cb_fullscreen_click(GtkAction * action);
gboolean menu_cb_view_toolbar(GtkAction *action);
gboolean menu_cb_show_scale(GtkAction * action);
gboolean menu_cb_show_routes(GtkAction * action);
gboolean menu_cb_show_tracks(GtkAction * action);
gboolean menu_cb_show_velvec(GtkAction * action);
gboolean menu_cb_show_poi(GtkAction * action);
gboolean menu_cb_category(GtkAction * action);

/* Callbacks for the "Auto-Center" submenu. */
gboolean menu_cb_autocenter(GtkAction *action, GtkRadioAction *current);

/* Callbacks for the "Go to" submenu. */
gboolean menu_cb_goto_latlon(GtkAction * action);
gboolean menu_cb_goto_gps(GtkAction * action);
gboolean menu_cb_goto_home(GtkAction * action);
gboolean menu_cb_goto_destination(GtkAction *action);
gboolean menu_cb_goto_nextway(GtkAction * action);
gboolean menu_cb_goto_nearpoi(GtkAction * action);

/* Callbacks for the "GPS" submenu. */
gboolean menu_cb_enable_gps(GtkAction * action);
gboolean menu_cb_gps_show_info(GtkAction * action);
gboolean menu_cb_gps_details(GtkAction * action);
gboolean menu_cb_gps_reset(GtkAction * action);

/* Callbacks for the other menu items. */
gboolean menu_cb_settings(GtkAction * action);
gboolean menu_cb_settings_gps(GtkAction * action);
gboolean menu_cb_settings_osm(GtkAction * action);
gboolean menu_cb_settings_colors(GtkAction * action);
gboolean menu_cb_settings_keys(GtkAction * action);
gboolean menu_cb_import_osm(GtkAction * action);
gboolean menu_cb_help(GtkAction * action);
gboolean menu_cb_about(GtkAction * action);

/* Callbacks for the "Location" context menu. */
gboolean cmenu_cb_loc_show_latlon(GtkAction * action);
gboolean cmenu_cb_loc_clip_latlon(GtkAction * action);
gboolean cmenu_cb_loc_route_to(GtkAction * action);
gboolean cmenu_cb_loc_distance_to(GtkAction * action);
gboolean cmenu_cb_loc_add_route(GtkAction * action);
gboolean cmenu_cb_loc_add_way(GtkAction * action);
gboolean cmenu_cb_loc_add_poi(GtkAction * action);
gboolean cmenu_cb_loc_set_gps(GtkAction * action);
gboolean cmenu_cb_loc_set_home(GtkAction * action);
gboolean cmenu_cb_loc_set_destination(GtkAction *action);

gboolean cb_poi_add(GtkAction * action);
gboolean cb_poi_search(GtkAction *action);
gboolean menu_cb_search_address(GtkAction *action);

/* Audio menu */
gboolean menu_cb_audio_toggle(GtkAction *action);

/* Callbacks for the "Waypoint" context menu. */
gboolean cmenu_cb_way_show_latlon(GtkAction * action);
gboolean cmenu_cb_way_show_desc(GtkAction * action);
gboolean cmenu_cb_way_clip_latlon(GtkAction * action);
gboolean cmenu_cb_way_clip_desc(GtkAction * action);
gboolean cmenu_cb_way_route_to(GtkAction * action);
gboolean cmenu_cb_way_distance_to(GtkAction * action);
gboolean cmenu_cb_way_delete(GtkAction * action);
gboolean cmenu_cb_way_add_poi(GtkAction * action);

/* Callbacks for the "POI" context menu. */
gboolean cmenu_cb_poi_route_to(GtkAction * action, gpointer data);
gboolean cmenu_cb_poi_distance_to(GtkAction * action, gpointer data);
gboolean cmenu_cb_poi_edit_poi(GtkAction * action, gpointer data);
gboolean cmenu_cb_poi_add_route(GtkAction * action, gpointer data);
gboolean cmenu_cb_poi_add_way(GtkAction * action, gpointer data);
gboolean cmenu_cb_poi_show_poi(GtkAction *action, gpointer data);
gboolean cmenu_cb_goto_poi(GtkAction * action, gpointer data);

/* Special button callbacks */
gboolean headphone_button_cb(gpointer data);

gboolean dicto_recording_cb(Dicto *d, gpointer data);

void path_waypoint_activated_cb(GtkTreeView *tree_view, GtkTreePath *path, GtkTreeViewColumn *column, gpointer data);

#endif
