/*
 * This file is part of mapper
 *
 * Copyright (C) 2007 Kaj-Michael Lang
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/*
 * A simple CLI interface to the mapper planet2sqlite import code.
 */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gstdio.h>

#include "osm.h"
#include "latlon.h"
#include "db.h"
#include "osm-db-import.h"

#define OSM_DB_FILE "osm-planet.db"

static gint
print_fail(const gchar *msg, gint ret)
{
g_printerr("ERROR: %s\n", msg);
return ret;
}

int main (int argc, char **argv)
{
gchar *in_file;
gchar *out_file;

if (argc<3)
	return print_fail("Missing arguments:\noutput.db input.osm.bz2\n\nInput file must be bz2 compressed OSM XML data.", 1);

if (argc<7)
	g_printf("No bounding box specified, importing everything.\n");

out_file=argv[1];
in_file=argv[2];
g_printf("Using input file: %s\n", in_file);
g_printf("Using output file: %s\n", out_file);

if (argc==7) {
	osm_import_set_bbox(TRUE, atof(argv[2]), atof(argv[3]), atof(argv[4]), atof(argv[5]));
} else {
	osm_import_set_bbox(FALSE, 0, 0, 0, 0);
}

if (osm_import(in_file, out_file)==FALSE) {
	return print_fail("Import failed", 4);
}
return 0;
}
