/*
 * Copyright (c) 2010 Andreas Henriksson <andreas@fatal.se>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTRCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __MAP_BUDDY_TRACKING_H__
#define __MAP_BUDDY_TRACKING_H__

#include <glib-object.h>
#include <location/location-gps-device.h>
#include <location/location-gpsd-control.h>
#include <champlain/champlain.h>

/*
 * Type macros.
 */
#define MAP_BUDDY_TYPE_TRACKING		(map_buddy_tracking_get_type ())
#define MAP_BUDDY_TRACKING(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), \
			MAP_BUDDY_TYPE_TRACKING, MapBuddyTracking))
#define MAP_BUDDY_IS_TRACKING(obj)	(G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
			MAP_BUDDY_TYPE_TRACKING))
#define MAP_BUDDY_TRACKING_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), \
			MAP_BUDDY_TYPE_TRACKING, MapBuddyTrackingClass))
#define MAP_BUDDY_IS_TRACKING_CLASS(klass)	\
			(G_TYPE_CHECK_CLASS_TYPE ((klass), \
			MAP_BUDDY_TYPE_TRACKING))
#define MAP_BUDDY_TRACKING_GET_CLASS(obj)	\
			(G_TYPE_INSTANCE_GET_CLASS ((obj), \
			MAP_BUDDY_TYPE_TRACKING, MapBuddyTrackingClass))

typedef struct _MapBuddyTracking        MapBuddyTracking;
typedef struct _MapBuddyTrackingPrivate MapBuddyTrackingPrivate;
typedef struct _MapBuddyTrackingClass   MapBuddyTrackingClass;

struct _MapBuddyTracking
{
  GObject parent_instance;

  /* instance members */

  /*< private >*/
  MapBuddyTrackingPrivate *priv;
};

struct _MapBuddyTrackingClass
{
  GObjectClass parent_class;

  /* class members */
};

GType map_buddy_tracking_get_type (void) G_GNUC_CONST;

/*
 * Method definitions.
 */
MapBuddyTracking *map_buddy_tracking_new (void);
void map_buddy_tracking_start (MapBuddyTracking *self, ChamplainView *view, LocationGPSDControl *gps_control);
gboolean map_buddy_tracking_record_location (MapBuddyTracking *self,
		LocationGPSDevice *device);
void map_buddy_tracking_stop (MapBuddyTracking *self, ChamplainView *view, LocationGPSDControl *gps_control);
void map_buddy_tracking_export_gpx (MapBuddyTracking *self, gchar *uri);
gboolean map_buddy_tracking_has_location_fixes (MapBuddyTracking *self);

#endif /* __MAP_BUDDY_TRACKING_H__ */

