/*
 * poi-manager.h - Headers for MapBuddyPoiManager
 * Copyright (C) 2010 Collabora Ltd
 * @author Cosimo Alfarano <cosimo.alfarano@collabora.co.uk>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __MAP_BUDDY_POI_MANAGER_H__
#define __MAP_BUDDY_POI_MANAGER_H__

#include "poi.h"

#include "poi-osm-fetcher.h"

#include <glib-object.h>

G_BEGIN_DECLS

typedef struct _MapBuddyPoiManager MapBuddyPoiManager;
typedef struct _MapBuddyPoiManagerClass MapBuddyPoiManagerClass;

struct _MapBuddyPoiManagerClass {
    GObjectClass parent_class;
};

struct _MapBuddyPoiManager {
    GObject parent;
};

GType poi_manager_get_type(void);

#define MAP_BUDDY_POI_MANAGER_TYPE (poi_manager_get_type())
#define MAP_BUDDY_POI_MANAGER(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), MAP_BUDDY_POI_MANAGER_TYPE, MapBuddyPoiManager))
#define MAP_MANAGER_POI_MANAGER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass), MAP_BUDDY_POI_MANAGER_TYPE, MapBuddyPoiManagerClass))
#define MAP_BUDDY_IS_POI_MANAGER(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), MAP_BUDDY_POI_MANAGER_TYPE))
#define MAP_BUDDY_IS_POI_MANAGER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass), MAP_BUDDY_POI_MANAGER_TYPE))
#define POI_MANAGER_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), MAP_BUDDY_POI_MANAGER_TYPE, MapBuddyPoiManagerClass))

MapBuddyPoiManager *map_buddy_poi_manager_dup (void);

void map_buddy_poi_manager_start (MapBuddyPoiManager *fetcher);

MapBuddyPoiOsmFetcher *map_buddy_poi_manager_get_fetcher (
    MapBuddyPoiManager *self);


G_END_DECLS

#endif /* #ifndef __MAP_BUDDY_POI_MANAGER_H__*/
