/*
 * Copyright (C) 2010 Pierre-Luc Beaudoin <pierre-luc@pierlux.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef _MAP_BUDDY_MERCHANT_H
#define _MAP_BUDDY_MERCHANT_H

#include <gtk/gtk.h>
#include <champlain/champlain.h>

G_BEGIN_DECLS


typedef struct _MapBuddyMerchant MapBuddyMerchant;

struct _MapBuddyMerchant {
  gchar *name;
  gchar *description;
  gchar *url;

  gchar *address;
  gchar *city;
  gchar *province;
  gchar *postal_code;
  gchar *country;
  gchar *country_code;

  gchar *phone;

  gdouble lat;
  gdouble lon;

  ChamplainMarker *marker; /* Weak pointer */
};

GType map_buddy_merchant_get_type (void) G_GNUC_CONST;

MapBuddyMerchant * map_buddy_merchant_copy (const MapBuddyMerchant *desc);

void map_buddy_merchant_free (MapBuddyMerchant *desc);

MapBuddyMerchant * map_buddy_merchant_new (void);

G_END_DECLS

#endif /* _MAP_BUDDY_MERCHANT_H */
