/*
 * contact-watcher.h - Header for ContactWatcher
 * Copyright (C) 2010 Guillaume Desmottes
 * Copyright (C) 2010 Collabora Ltd
 * @author Guillaume Desmottes <gdesmott@gnome.org>
 * @author Alban Crequy <alban.crequy@collabora.co.uk>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __CONTACT_WATCHER_H__
#define __CONTACT_WATCHER_H__

#include <glib-object.h>
#include <telepathy-glib/contact.h>

G_BEGIN_DECLS

typedef struct _ContactWatcher ContactWatcher;
typedef struct _ContactWatcherClass ContactWatcherClass;

struct _ContactWatcherClass {
    GObjectClass parent_class;
};

struct _ContactWatcher {
    GObject parent;
};

GType contact_watcher_get_type(void);

/* TYPE MACROS */
#define CONTACT_WATCHER_TYPE \
  (contact_watcher_get_type())
#define CONTACT_WATCHER(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), CONTACT_WATCHER_TYPE, ContactWatcher))
#define CONTACT_WATCHER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass), CONTACT_WATCHER_TYPE, ContactWatcherClass))
#define CONTACT_IS_WATCHER(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), CONTACT_WATCHER_TYPE))
#define CONTACT_IS_WATCHER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass), CONTACT_WATCHER_TYPE))
#define CONTACT_WATCHER_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACT_WATCHER_TYPE, ContactWatcherClass))

ContactWatcher * contact_watcher_new (void);

void contact_watcher_start (ContactWatcher *watcher);

G_END_DECLS

#endif /* #ifndef __CONTACT_WATCHER_H__*/
