/* 
 * conf.c - Headers for GConf manager
 * Copyright (C) 2010 Collabora Ltd
 * @author Cosimo Alfarano <cosimo.alfarano@collabora.co.uk>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTRCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __MAP_BUDDY_CONF_H__
#define __MAP_BUDDY_CONF_H__

#include <gconf/gconf-client.h>
#include <glib-object.h>

G_BEGIN_DECLS

#define MAP_BUDDY_TYPE_CONF                  (map_buddy_conf_get_type ())
#define MAP_BUDDY_CONF(obj)                  (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAP_BUDDY_TYPE_CONF, MapBuddyConf))
#define MAP_BUDDY_CONF_CLASS(klass)          (G_TYPE_CHECK_CLASS_CAST ((klass), MAP_BUDDY_TYPE_CONF, MapBuddyConfClass))
#define MAP_BUDDY_IS_CONF(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAP_BUDDY_TYPE_CONF))
#define MAP_BUDDY_IS_CONF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAP_BUDDY_TYPE_CONF))
#define MAP_BUDDY_CONF_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), MAP_BUDDY_TYPE_CONF, MapBuddyConfClass))

#define MAP_BUDDY_CONF_ERROR g_quark_from_static_string ("map-buddy-conf-error-quark")

typedef enum
{
  /* generic error */
  MAP_BUDDY_CONF_ERROR_FAILED,
  /* GCONF KEY ERROR */
  MAP_BUDDY_CONF_ERROR_GCONF_KEY
} MapBuddyConfError;

typedef struct _MapBuddyConfPrivate MapBuddyConfPrivate;
typedef struct
{
  GObject parent;

  /* private */
  MapBuddyConfPrivate *priv;
} MapBuddyConf;

typedef struct
{
  GObjectClass parent_class;
} MapBuddyConfClass;

GType map_buddy_conf_get_type (void);

MapBuddyConf *map_buddy_conf_dup (void);
gchar *map_buddy_conf_get_osm_icon_for (MapBuddyConf *self,
    const gchar *feature, const gchar *feature_type, GError **error);
gchar *map_buddy_conf_get_default_icon (MapBuddyConf *self, GError **error);
const GSList *map_buddy_conf_get_shown_features (MapBuddyConf *self,
    GError **error);

G_END_DECLS

#endif // __MAP_BUDDY_CONF_H__
