/*
 * Copyright (C) 2010 Pierre-Luc Beaudoin <pierre-luc@pierlux.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTRCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef MAP_BUDDY_MERCHANT_MARKER_H
#define MAP_BUDDY_MERCHANT_MARKER_H

#include <champlain/champlain.h>
#include <glib-object.h>
#include <clutter/clutter.h>

G_BEGIN_DECLS

#define MAP_BUDDY_TYPE_MERCHANT_MARKER     (map_buddy_merchant_marker_get_type())
#define MAP_BUDDY_MERCHANT_MARKER(obj)     (G_TYPE_CHECK_INSTANCE_CAST((obj), MAP_BUDDY_TYPE_MERCHANT_MARKER, MapBuddyMerchantMarker))
#define MAP_BUDDY_MERCHANT_MARKER_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass),  MAP_BUDDY_TYPE_MERCHANT_MARKER, MapBuddyMerchantMarkerClass))
#define MAP_BUDDY_IS_MERCHANT_MARKER(obj)  (G_TYPE_CHECK_INSTANCE_TYPE((obj), MAP_BUDDY_TYPE_MERCHANT_MARKER))
#define MAP_BUDDY_IS_MERCHANT_MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass),  MAP_BUDDY_TYPE_MERCHANT_MARKER))
#define MAP_BUDDY_MERCHANT_MARKER_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj),  MAP_BUDDY_TYPE_MERCHANT_MARKER, MapBuddyMerchantMarkerClass))

typedef struct _MapBuddyMerchantMarkerPrivate MapBuddyMerchantMarkerPrivate;

typedef struct _MapBuddyMerchantMarker MapBuddyMerchantMarker;
typedef struct _MapBuddyMerchantMarkerClass MapBuddyMerchantMarkerClass;

struct _MapBuddyMerchantMarker
{
  ChamplainMarker base;

  MapBuddyMerchantMarkerPrivate *priv;
};

struct _MapBuddyMerchantMarkerClass
{
  ChamplainMarkerClass parent_class;
};

GType map_buddy_merchant_marker_get_type (void);

ClutterActor *map_buddy_merchant_marker_new (void);

G_END_DECLS

#endif
