/*
 * Copyright (C) 2010 Pierre-Luc Beaudoin <pierre-luc@pierlux.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#if HAVE_CONFIG_H
#include <config.h>
#endif

#include "map-buddy-window.h"

#include <gtk/gtk.h>
#include <clutter-gtk/clutter-gtk.h>
#include <locale.h>
#include <glib/gi18n.h>
#include <libosso.h>

#define OSSO_SERVICE "com.pierlux."PACKAGE

typedef struct _AppData AppData;

struct _AppData
{
  HildonProgram *program;
  MapBuddyWindow *window;
};

int main (int argc, char* argv[])
{
  osso_context_t *osso = NULL;
  ChamplainCache *cache;

  AppData *data = g_new0 (AppData, 1);

  /* Initialize the locale stuff: */
  bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);

  /* Inititialize GTK+ and hildon: */
  g_thread_init (NULL);
  hildon_gtk_init (&argc, &argv);
  gtk_clutter_init (&argc, &argv);

  osso = osso_initialize (OSSO_SERVICE, VERSION, TRUE, NULL);

  /* Create the hildon application and setup the title: */
  data->program = HILDON_PROGRAM (hildon_program_get_instance ());
  g_set_application_name (_("Map Buddy"));

  /* Create the window for our application: */
  data->window = map_buddy_window_new ();
  hildon_program_add_window (data->program, HILDON_WINDOW (data->window));

  /* Show the main window and start the mainloop,
   * quitting the mainloop when it the main window is hidden:
   */
  g_signal_connect (data->window, "destroy",
      G_CALLBACK (gtk_main_quit), NULL);

  gtk_widget_show (GTK_WIDGET (data->window));

  gtk_main ();

  /* clean cache once window is closed */
  cache = champlain_cache_dup_default ();
  champlain_cache_purge (cache);
  g_object_unref (cache);

  /* Clean up: */
  g_free (data);
  osso_deinitialize (osso);

  return 0;
}
