/*
Mancala - A Historical Board Game
Copyright (C) 2009-2010 A.H.M.Mahfuzur Rahman 65mahfuz90@gmail.com
Copyright (c) 2010 Reto Zingg g.d0b3rm4n@gmail.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of
the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


#ifndef MOVEGENERATOR_H
#define MOVEGENERATOR_H


#include <QList>
// #include <kdebug.h>

class GameController;
class GameInfo;
class Node;

class MoveGenerator{

    public:

        MoveGenerator(int gameDifficulty,GameInfo *gameInfo,GameController *gameController);

        void changeDifficulty(int gameDifficulty){
            // kDebug() << "GameDifficulty Changed to: " << gameDifficulty;
            m_gameDifficulty = gameDifficulty;
        }
        //Will be called when we need a move and pass the current board state
        int bestMove(QList<int> ,bool );
        int maxValue(Node *currentNode,int alpha,int beta);
        int minValue(Node *currentNode,int alpha,int beta);

        void copyBoard(Node* to,Node* from);
        void copyBoard(Node *to,QList<int>board);
        void simulateMoves(Node *currentNode,QList<Node*>& );

        bool isGameOver(QList<int> board);
        void showBoardState(Node* node);

    private:


        QList<int> allCupIndexes;
        QList<int> allEvaluations;
        GameInfo* m_gameInfo;
        GameController* m_gameController;
        int m_searchDepth;
        int m_gameDifficulty;
        int m_depthList[3];

};

//Node of the Minimax Tree
class Node{

    public:
        Node(GameInfo *gameInfo);

        int evaluationFunction(GameController* controller);
        QList<int> getBoard(){ return m_boardState; }
        void setBoard(QList<int>board);

        void setDepth(int depth){ m_depth = depth;}
        void setTurn(bool turn){ m_humanTurn = turn;}
        void setMove(int move){ m_move = move;}

        int depth() const{ return m_depth;}
        int move() const{return m_move;}
        bool turn() const{ return m_humanTurn;}


    private:

        GameInfo* m_gameInfo;
        int m_depth;
        bool m_humanTurn;
        QList<int> m_boardState;
        int m_move;     //from which cup the move has been generated
};

#endif // MOVEGENERATOR_H
