/*
Mancala - A Historical Board Game
Copyright (C) 2009-2010 A.H.M.Mahfuzur Rahman 65mahfuz90@gmail.com
Copyright (c) 2010 Reto Zingg g.d0b3rm4n@gmail.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of
the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "MainWindow.h"

#include <QMainWindow>
#include <QStatusBar>
#include <QGraphicsView>
#include <QFile>
#include <QPushButton>
#include <QLabel>
#include <QAction>
#include <QtGui>
#include <QStackedWidget>

//#include <kdebug.h>
//#include <kaction.h>
//#include <klocale.h>
//#include <kactioncollection.h>
//#include <kstandardaction.h>
//#include <kapplication.h>
//#include <kstandarddirs.h>
//#include <kstatusbar.h>
//#include <kmenu.h>
//#include <kstandardgameaction.h>
//#include <kselectaction.h>
//#include <kgameclock.h>

#include "ThemeManager.h"
#include "GameInfo.h"
#include "GraphicsScene.h"
#include "settingswidget.h"
//#include "GraphicsView.h"

MainWindow::MainWindow(QWidget* parent) {

    m_StackedWidget = new QStackedWidget();
    setWindowTitle("Mancala");
    setupGame();
    setupWidgets();
    setupActions();

}

MainWindow::~MainWindow(){}

void MainWindow::setupGame(){

    //gameInfo
    setGameName(QString("kalah")) ;
    m_gameNameId = 0;
    m_gameInfo = new GameInfo();

    m_gameInfo->setGameInfo(m_gameName);

    //gameTheme
    QString fileName = QString("/opt/mancala/data/themes/theme_%1.svg").arg(m_gameName);
    m_gameTheme = new ThemeManager(fileName);
    m_gameTheme->setTheme(m_gameName);

    //gameController
    m_gameController = new GameController(m_gameInfo);

}

void MainWindow::setupWidgets(){

    //status bar
//    statusBar()->insertItem(QString(),4);
//    statusBar()->insertItem(tr("Turn: your"), 0 );
//    statusBar()->insertItem(tr( "Human Player: 0"),1 );
//    statusBar()->insertItem(tr( "Computer: 0"),2);

    settings = new SettingsWidget(this);

    //set to m_gameNameList - we should done it initially
    reader = new QXmlStreamReader();
    setGameName();
    settings->setGameNames(m_gameNameList);

    connect(settings,
            SIGNAL(start()),
            this,
            SLOT(slotStartGame()));

    connect(settings,
            SIGNAL(levelChanged(int)),
            this,
            SLOT(slotChangeDifficulty(int)));

    connect(settings,
            SIGNAL(gameChanged(int)),
            this,
            SLOT(slotChangeGameName(int)));

    m_StackedWidget->addWidget(settings);

    msgLabel = new QLabel();
    turnLabel = new QLabel("Turn: your");
    humanScore = new QLabel("Human: 0");
    aiScore = new QLabel("Computer: 0");

    statusBar()->addWidget(turnLabel);
    statusBar()->addWidget(msgLabel,1);
    statusBar()->addWidget(humanScore);
    statusBar()->addWidget(aiScore);


    /*setting up the connections for m_gameTheme and m_gameController with this*/
    connect(this, SIGNAL( signalLoadTheme()), m_gameTheme, SLOT( slotLoadTheme() ));
    emit signalLoadTheme();
    //showScore
    connect(m_gameController,SIGNAL(signalShowScore(int,bool)),
            this,SLOT(slotShowScore(int,bool)));
    //showTurn
    connect(m_gameController,SIGNAL(signalShowTurn(bool)),this,SLOT(slotShowTurn(bool)));
    //Message from gameController
    connect(m_gameController,SIGNAL(signalMessage(QString)),this,SLOT(slotMessage(QString)));
    connect(m_gameController,SIGNAL(signalGameOver()),this,SLOT(slotShowGameOver()));
    connect(this,SIGNAL(signalGameDifficulty(GameController::Difficulty)),m_gameController,SLOT(slotGameDifficulty(GameController::Difficulty)));


    //GraphicsScene and GraphicsView
    m_scene = new GraphicsScene(m_gameInfo,m_gameTheme,m_gameController,this);
    m_view = new QGraphicsView(m_scene, this);

    m_StackedWidget->addWidget(m_view);

    m_StackedWidget->setCurrentIndex(0);

    setCentralWidget(m_StackedWidget);

}



void MainWindow::setupActions(){

    mainMenu = menuBar()->addMenu("Main");

//    helpAction = new QAction(tr("Help"), this);
//    connect(helpAction,
//            SIGNAL(triggered()),
//            this,
//            SLOT(help()));

    //New Game KSelectAction ---------------------------
    // newGameAct = new KSelectAction(i18n("&New Game"),this);
    // actionCollection()->addAction("new_game",newGameAct);

    restartGameAction = new QAction(tr("restart game"), this);

    connect(restartGameAction,
            SIGNAL(triggered()),
            this,
            SLOT(slotStartGame()));

    mainMenu->addAction(restartGameAction);

    newGameAction = new QAction(tr("new game"), this);

    connect(newGameAction,
            SIGNAL(triggered()),
            this,
            SLOT(slotShowSettings()));

    mainMenu->addAction(newGameAction);


    helpAction = new QAction(tr("Help"), this);

    connect(helpAction,
            SIGNAL(triggered()),
            this,
            SLOT(help()));

    mainMenu->addAction(helpAction);

//    //set to m_gameNameList - we should done it initially
//    reader = new QXmlStreamReader();
//    setGameName();

//    newGameAct->setItems(m_gameNameList);
//    newGameAct->setCurrentItem(0);
    //kDebug() << "Current Text:" << newGameAct->currentText();

//    connect( newGameAct , SIGNAL(triggered(int)),m_gameController, SLOT(slotGameOverForNewGame(int) ) );
//    connect( m_gameController,SIGNAL(signalNewGame(int)),this,SLOT(newGame(int)));


    //Quit Action ------------------
    // KStandardAction::quit(kapp, SLOT(quit()),  actionCollection());

    // KAction* restartGame = new KAction(this);
//    restartGame->setText(tr("&Restart Game"));
//    actionCollection()->addAction("restartgame",restartGame);
//    connect(restartGame,SIGNAL(triggered(bool)),m_gameController,SLOT(slotGameOverForRestartGame()) );

    // Difficulty
//    KGameDifficulty::init(this, this, SLOT(slotChangeDifficulty(KGameDifficulty::standardLevel)));
//    KGameDifficulty::addStandardLevel(KGameDifficulty::Easy);
//    KGameDifficulty::addStandardLevel(KGameDifficulty::Medium);
//    KGameDifficulty::addStandardLevel(KGameDifficulty::Hard);
//    KGameDifficulty::setLevel(KGameDifficulty::Easy);

    // setupGUI();
}


//---------------------parsting starts -------------------------

//ready the file to be parsed by reader
void MainWindow::setGameName(){

    QString fileName = QString("/opt/mancala/data/gamelist.xml");
    //kDebug() << "File Name: " << fileName;
    if(fileName.isEmpty()) return;

    QFile infoFile(fileName);
    if (!infoFile.open(QFile::ReadOnly | QFile::Text)) return;
    parseXml(&infoFile);

}

//parse gamelist.xml file
void MainWindow::parseXml(QIODevice *device){

    reader->setDevice(device);

    while(!reader->atEnd()){
        reader->readNext();

        if(reader->isStartElement()){

            if(reader->name() == "gamelist")
                parseNames();
            else reader->raiseError(QObject::tr("This is not the exact file Needed"));
        }
    }

}

//set the names in m_gameNameList
void MainWindow::parseNames(){

    Q_ASSERT(reader->isStartElement() && reader->name() == "gamelist");

    while(!reader->atEnd()){
        reader->readNext();

        if(reader->isEndElement())
            break;

        if(reader->isStartElement()){

            Q_ASSERT( reader->name() == "name");
            m_gameNameList << reader->readElementText();

        }
    }

}

//------------------------------ parsing ends ---------------------------



//------------------------------ slot zone starts -------------------------

//Now working with this
void MainWindow::newGame(int gameId){

    //kDebug() << "newGame called";
    qDebug() << "newGame called" << gameId;
    m_gameName = m_gameNameList[gameId];

    //gameInfo
    m_gameInfo->initializeAll();
    m_gameInfo->setGameInfo(m_gameName);

    //gameTheme
    m_gameTheme->setTheme(m_gameName);
    emit signalLoadTheme();

    m_scene->slotStartGame();
}

void MainWindow::slotStartGame(){

    newGame(m_gameNameId);

    m_StackedWidget->setCurrentIndex(1);

    // TODO: this looks nasty, is there no other way?
    // w/o the gameboard is tiny, just after a resize it adapts!?
    QSize oldSize = this->size();
    this->resize(100,100);
    this->resize(oldSize);

    slotMessage(QString("New game started..."));

}

void MainWindow::slotShowScore(int score,bool human){

    if(human){
        // statusBar()->changeItem(tr("Human Player: %1",score),1);
       humanScore->setText(tr("Human: %1").arg(score) );
    }
    else{
        // statusBar()->changeItem(tr("Computer: %1",score),2);
        aiScore->setText(tr("Computer: %1").arg(score) );
    }
}

void MainWindow::slotShowTurn(bool human){

//    if(human)
//        // statusBar()->changeItem(tr("Turn: your"),0);
//    else
//        // statusBar()->changeItem(tr("Turn: computer"),0);

    if(human){
        turnLabel->setText(tr("Turn: your"));
    }
    else{
        turnLabel->setText(tr("Turn: computer"));
    }
}

void MainWindow::slotMessage(QString str){

    // statusBar()->changeItem(str,4);
    msgLabel->setText(str);
}


void MainWindow::slotPause(){

}

void MainWindow::slotShowGameOver(){
    slotMessage( tr("Game Over") );

    QTimer::singleShot(2500,this,SLOT(slotShowSettings()));
}

void MainWindow::slotShowSettings(){
    m_StackedWidget->setCurrentIndex(0);
}

//void MainWindow::slotChangeDifficulty(KGameDifficulty::standardLevel level){
//
//    switch(level) {
//
//        case KGameDifficulty::Easy:
//            emit signalGameDifficulty(GameController::EASY);
//            break;
//        case KGameDifficulty::Medium:
//            emit signalGameDifficulty(GameController::MEDIUM);
//            break;
//        case KGameDifficulty::Hard:
//            emit signalGameDifficulty(GameController::HARD);
//            break;
//    }
//}

void MainWindow::slotChangeDifficulty(int level){

    switch(level){
    case Easy:
        emit signalGameDifficulty(GameController::EASY);
        qDebug() << "Level: " << level;
        break;
    case Medium:
        emit signalGameDifficulty(GameController::MEDIUM);
        qDebug() << "Level: " << level;
        break;
    case Hard:
        emit signalGameDifficulty(GameController::HARD);
        qDebug() << "Level: " << level;
        break;
    }
}

void MainWindow::slotChangeGameName(int game){
    qDebug() << "slotChangeGameName:" << game;
    setGameName(m_gameNameList[game]);
    m_gameNameId = game;
}

void MainWindow::help(){
    QDesktopServices::openUrl(QUrl("file:///opt/mancala/data/mancala.html"));
}


//----------------------------- slot zone ends --------------------------


void MainWindow::resizeEvent(QResizeEvent *event){

    //We need scroll Bars to Off so that there is no probability of recursing fitInView
    //m_view->fitInView(QRect(QPoint(0,0), m_scene->sceneRect().size().toSize()), Qt::KeepAspectRatio);
    m_view->fitInView(QRect(QPoint(0,0), m_scene->sceneRect().size().toSize()));
    // KXmlGuiWindow::resizeEvent(event);

}

void MainWindow::setGameName(QString gameName){
    m_gameName = gameName; 
}
