/*
Mancala - A Historical Board Game
Copyright (C) 2009-2010 A.H.M.Mahfuzur Rahman 65mahfuz90@gmail.com
Copyright (c) 2010 Reto Zingg g.d0b3rm4n@gmail.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of
the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "Kalah.h"

#include <math.h>

#include <QGraphicsScene>
#include <QGraphicsSvgItem>
// #include <kdebug.h>

#include "GameInfo.h"
#include "Board.h"
#include "Stone.h"


Kalah::Kalah(GameInfo* info, Kalah::side p, QGraphicsSvgItem *parent)
: QGraphicsSvgItem(parent){

    m_side = p;
    m_gameInfo = info;
    m_board = qgraphicsitem_cast<Board*>(parent);

    setSharedRenderer(m_board->renderer());
    setElementId("kalah");
    setZValue(2);
    initialSetup();
    setupText();

}


//The Drawing of Kalah Items
void Kalah::initialSetup(){

    qreal gapWidth = m_board->boundingRect().width() * ( 0.2 / ( m_gameInfo->numCupsPerRow() + m_gameInfo->numKalahs() + 1 ) );

    m_size.setWidth( m_board->boundingRect().width() * 0.8 / ( m_gameInfo->numCupsPerRow() + m_gameInfo->numKalahs() ) );
    m_size.setHeight( m_board->boundingRect().height() * 0.8 );

    //kalahWidth and cupWidth are same
    if(m_side == Left)
        m_pos.setX( m_board->boundingRect().x() + gapWidth );
    else m_pos.setX( m_board->boundingRect().x() +  gapWidth + ( gapWidth + m_size.width() ) * ( m_gameInfo->numCupsPerRow() + 1 ) );
    m_pos.setY( m_board->boundingRect().y() + m_board->boundingRect().height() * 0.1 );

    //scaling the kalah object
    qreal kalahScaleX = m_size.width() / boundingRect().width();
    qreal kalahScaleY = m_size.height()/ boundingRect().height();

    m_mid_point.setX( m_pos.x() + m_size.width() / 2 );
    m_mid_point.setY( m_pos.y() + m_size.height() / 2 );

    setPos(m_pos);
    scale(kalahScaleX,kalahScaleY);
}

void Kalah::setupText(){

    m_text = new QGraphicsSimpleTextItem("0",m_board);
    m_text->setFont( QFont("Comic Sans MS", 24, QFont::Bold) );
    m_text->setPen(QPen(QColor("darkslateblue"), 1.5, Qt::SolidLine, Qt::RoundCap, Qt::RoundJoin));
    QLinearGradient gradient(0, 0, 0, 100);
    gradient.setColorAt(0.0, "mediumslateblue");
    gradient.setColorAt(1.0, "cornsilk");
    m_text->setBrush(gradient);

    int textX = m_pos.x() + m_size.width();
    textX -= m_text->boundingRect().size().width() + 15;

    int textY =  m_pos.y() + m_size.height();
    textY -= m_text->boundingRect().size().height() - 15;

    m_text->scale(0.8,0.8);
    m_text->setPos(textX,textY);
    m_text->setZValue(4);
    m_text->setVisible(false);
}

void Kalah::updateStoneList(Stone* stoneItem){

    //kDebug() << "In Kalah" ;
    QPointF *stonePos;

    m_text->setVisible(false);
    m_stone.append(stoneItem);

    //calculate stone postion and place it
    stonePos = calculateStonePosition(stoneItem);
    stoneItem->animateStones(QPointF(stonePos->x(),stonePos->y()));

    //we want to change the text showing ball number
    if( m_stone.count() ){

        m_text->setText( QString("%1").arg(m_stone.count() ) );
        m_text->setVisible(true);

        update();
    }

    //kDebug() << "Returning";
}


//calculate stonePostion in Kalah
QPointF* Kalah::calculateStonePosition(Stone* stone){

    QPointF *returnPoint = new QPointF();

    qreal diameterCup = qMin(m_size.width(),m_size.height());

    int initialLength = qrand() % (int) diameterCup / 3;
    int angle = qrand() % 360;

    qreal posX = middlePoint().x() + initialLength * cos(angle * M_PI / 180);
    qreal posY = middlePoint().y() + initialLength * sin(angle * M_PI / 180);

    if( ( posX + stone->size().width()) > ( m_pos.x() + 0.7 * m_size.width() ) )
        posX -= stone->size().width();
    else if( posX < ( m_pos.x()+ 0.3 * m_size.width() ) )
        posX += stone->size().width();

    if( ( posY + stone->size().height() ) > ( m_pos.y() + 0.7 * m_size.height() ) )
        posY -= stone->size().height();
    else if( posY < (m_pos.y() + 0.3 < m_size.height() ) )
        posY += stone->size().height();

    returnPoint->setX(posX);
    returnPoint->setY(posY);

    return returnPoint;
}
