/*
Mancala - A Historical Board Game
Copyright (C) 2009-2010 A.H.M.Mahfuzur Rahman 65mahfuz90@gmail.com
Copyright (c) 2010 Reto Zingg g.d0b3rm4n@gmail.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of
the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "GraphicsScene.h"

#include <QGraphicsSceneMouseEvent>
#include <QSvgRenderer>
#include <QPainter>
#include <QWidget>

// #include <kdebug.h>
// #include <ksvgrenderer.h>

#include "GameInfo.h"
#include "ThemeManager.h"
#include "Board.h"
#include "Stone.h"
#include "GameController.h"
#include "MainWindow.h"

GraphicsScene::GraphicsScene(GameInfo *gameInfo,ThemeManager *theme,GameController*
                             gameController ,QWidget *parent)
    : QGraphicsScene(parent){

    m_gameInfo = gameInfo;
    m_gameTheme = theme;
    m_parent = (MainWindow*)parent;
    m_gameController = gameController;

    setSceneRect(m_parent->windowRect());
    setupGameNecessaries();

    connect( this,SIGNAL(signalMouseClicked(int)),
             m_gameController , SLOT(slotMouseClicked(int)) );
    connect( m_gameController,SIGNAL(signalRestartGame()),this,SLOT(slotStartGame()));

}

void GraphicsScene::showGameName(){

    qreal posX,posY,width,height,scaleX,scaleY;

    m_gameName = new QGraphicsSvgItem(0);
    m_gameName->setSharedRenderer(m_gameTheme);
    m_gameName->setElementId("GameName");

    posX = sceneRect().x() + sceneRect().width() * 0.40; // 0.30
    posY = sceneRect().y() + sceneRect().height() * 0.05; // 0.10
    width = 0.20 * sceneRect().width(); // 0.40
    height = width / 10 ; // 5

    scaleX = width / ( m_gameName->boundingRect().width() );
    scaleY = height / ( m_gameName->boundingRect().height() ) ;
    m_gameName->scale(scaleX,scaleY);

    m_gameName->setPos(posX,posY);

    addItem(m_gameName);
}


void GraphicsScene::setupGameNecessaries(){

    // showGameName();
    m_board = new Board(m_gameInfo, m_gameTheme);

    for( int i = 0; i < m_gameInfo->stones(); i++)
        m_stones << new Stone(i, m_gameInfo, m_gameTheme, m_board);

    m_board->manipulateStones(m_stones);
    addItem(m_board);

    //For the first time
    m_gameController->setBoardItem(m_board);

    renderBackground(sceneRect().size().toSize(),true);

}

void GraphicsScene::deleteGameNecessaries(){

    Stone *stone;
    // delete m_gameName;

    while(m_stones.count()){
        stone = m_stones.front();
        m_stones.pop_front();
        delete stone;
    }

    if(m_board != NULL){
        delete m_board;
        m_board = NULL;
    }

}


void GraphicsScene::slotStartGame(){

    deleteGameNecessaries();
    setupGameNecessaries();

    update(sceneRect());

    m_gameController->initializeGameController();
    m_gameController->setBoardItem(m_board);

}


void GraphicsScene::mousePressEvent(QGraphicsSceneMouseEvent *event){

    // kDebug() << event->scenePos();
    int cupIndex = m_board->findCupIndex(event->scenePos());
    emit signalMouseClicked(cupIndex);
}

QPixmap GraphicsScene::renderBackground(const QSize& size,bool newGame){
    QPixmap pix;
    QString cacheName("BackGround");

    if( !QPixmapCache::find(cacheName, pix) || newGame)
    {
        QSvgRenderer* m_renderer = new QSvgRenderer(m_gameTheme->current());

        pix = QPixmap(size);
        pix.fill(Qt::transparent);
        QPainter painter(&pix);
        m_renderer->render( &painter, "BackGround");
        QPixmapCache::insert(cacheName, pix);
    }

    return pix;
}

void GraphicsScene::drawBackground(QPainter* painter, const QRectF &rect){

    QSize size = m_parent->windowRect().size().toSize();
    painter->drawPixmap( 0, 0, renderBackground( size , false ) );

}

