/*  
 *  "Ultimate" AI Algorithm -- ai-ultimate.c
 *  Kevin Riggle
 *  http://cmancala.sourceforge.net
 *  $Source: /cvsroot/cmancala/mancala/src/Attic/ai-ultimate.c,v $
 *  $Revision: 1.12.2.1 $
 *  $Date: 2003/12/29 05:49:52 $
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include "mancala.h"
#include "ai.h"
#include "ai-init.h"

static int aiUltimate(int *aiBoard, int *humanBoard, int depth, FILE *log);

/* api function */

int aiMove(int *aiBoard, int *humanBoard) {

	return aiInit(aiBoard, humanBoard, "ultimate.log", aiUltimate);

}

int aiUltimate(int *aiBoard, int *humanBoard, int depth, FILE *log) {

	int aiBoardTemp[BOARD_MAX+1], humanBoardTemp[BOARD_MAX+1];
	int *outcomes[BOARD_MAX+1];
	int ai_min[BOARD_MAX+1], human_max[BOARD_MAX+1];
	int i, j, k, result, bestmove;

	bestmove = result = 0;

	/* allocate memory to store the results */
	for (i=0; i<=BOARD_MAX; i++)
		if ((outcomes[i] = (int *) calloc(BOARD_MAX+1, sizeof(int)))
			== NULL)
			printf("Cannot allocate memory...\n");

	for (i=1; i<=BOARD_MAX; i++) {
	for (j=1; j<=BOARD_MAX; j++) {

		/* make another temporary copy of the boards */ 
		for (k=0; k<=BOARD_MAX; k++) {
			aiBoardTemp[k] = aiBoard[k];
			humanBoardTemp[k] = humanBoard[k];
		}

		/*  RECURSION
		if (move(aiBoardTemp, humanBoardTemp, i) == 0)
			aiUltimate(aiBoardTemp, humanBoardTemp, (depth+1), log);
		if (move(humanBoardTemp, aiBoardTemp, j) == 0)
			aiUltimate(humanBoardTemp, aiBoardTemp, {depth+1), log);
		END RECURSION */

		move(aiBoardTemp, humanBoardTemp, i);
		move(humanBoardTemp, aiBoardTemp, j);

		result = (aiBoardTemp[0] - aiBoard[0]) 
			- (humanBoardTemp[0] - humanBoard[0]);

		*(outcomes[i] + j) = result;

		printf("%d ", *(outcomes[i] + j));

	}
	printf("\n");
	}

	/* find the ai's min move and the human's max move for each row/col */
	for (i=1; i<=BOARD_MAX; i++)
	for (j=1; j<=BOARD_MAX; j++) {
		ai_min[i] = human_max[j] = 0;
		ai_min[i] = (*(outcomes[i] + j) < ai_min[i])
				? *(outcomes[i] + j) : ai_min[i];
		human_max[j] = (*(outcomes[j] + i) > human_max[j])
				? *(outcomes[j] + i) : human_max[j];
		printf("A @ %d: %d; H @ %d: %d\n", i, ai_min[i], j,
			human_max[j]);
	}

	/* free the calloc()s!  free the calloc()s! */
	for (i=0; i<=BOARD_MAX; i++)
		free(outcomes[i]);

	return bestmove;

}

/*   End ai-ultimate.c   */
