/*
 * This file is part of meego-keyboard 
 *
 * Copyright (C) 2010-2011 Nokia Corporation and/or its subsidiary(-ies). All rights reserved.
 *
 * Contact: Mohammad Anwari <Mohammad.Anwari@nokia.com>
 *
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this list 
 * of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice, this list 
 * of conditions and the following disclaimer in the documentation and/or other materials 
 * provided with the distribution.
 * Neither the name of Nokia Corporation nor the names of its contributors may be 
 * used to endorse or promote products derived from this software without specific 
 * prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL 
 * THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */


#include "ut_magnifier.h"
#include <magnifier.h>
#include <MApplication>
#include <MTheme>

#include <QFile>
#include <QTextStream>

namespace QTest
{

    template<>
    char *toString(const QFont &font)
    {
        QString string;
        QTextStream stream(&string);

        //print most important fields only
        stream << "QFont("
               << "family = \"" << font.family() << "\", "
               << "pointSize = " << font.pointSize() << ", "
               << "pixelSize = " << font.pixelSize() << ", ...)";

        return qstrdup(string.toLatin1());
    }

}

void Ut_Magnifier::initTestCase()
{
    static int argc = 1;
    static char *app_name[1] = { (char *) "ut_magnifier" };

    // Avoid waiting if im server is not responding
    MApplication::setLoadMInputContext(false);
    app = new MApplication(argc, app_name);

    MTheme::instance()->loadCSS(":test.css");
}

void Ut_Magnifier::cleanupTestCase()
{
    delete app;
    app = 0;
}

void Ut_Magnifier::init()
{
    subject = new Magnifier(0);
}

void Ut_Magnifier::cleanup()
{
    delete subject;
    subject = 0;
}

void Ut_Magnifier::testCreate()
{
    QVERIFY(subject != 0);
}

void Ut_Magnifier::testOther()
{
    QPointF pos(100, 20);

    QVERIFY(subject->pos() != pos);
    subject->setPos(pos);
    QVERIFY(subject->pos() == pos);
}

QTEST_APPLESS_MAIN(Ut_Magnifier);

