/*
 * This file is part of meego-keyboard 
 *
 * Copyright (C) 2010-2011 Nokia Corporation and/or its subsidiary(-ies). All rights reserved.
 *
 * Contact: Mohammad Anwari <Mohammad.Anwari@nokia.com>
 *
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this list 
 * of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice, this list 
 * of conditions and the following disclaimer in the documentation and/or other materials 
 * provided with the distribution.
 * Neither the name of Nokia Corporation nor the names of its contributors may be 
 * used to endorse or promote products derived from this software without specific 
 * prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL 
 * THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 */

#include "mimkeyvisitor.h"
#include "mimabstractkeyarea.h"
#include "mimkey.h"

namespace MImKeyVisitor
{
    SpecialKeyFinder::SpecialKeyFinder(FindMode newMode)
        : MImAbstractKeyVisitor()
        , mShiftKey(0)
        , mDeadKey(0)
        , mode(newMode)
    {}

    MImAbstractKey *SpecialKeyFinder::shiftKey() const
    {
        return mShiftKey;
    }

    MImAbstractKey *SpecialKeyFinder::deadKey() const
    {
        return mDeadKey;
    }

    bool SpecialKeyFinder::operator()(MImAbstractKey *key)
    {
        if (!key) {
            return false;
        }

        if (key->isShiftKey()) {
            mShiftKey = key;
        } else if (key->isDeadKey()) {
            mDeadKey = key;
        }

        switch (mode) {
            case FindShiftKey:
                if (mShiftKey) {
                    return true;
                }
                break;

            case FindDeadKey:
                if (mDeadKey) {
                    return true;
                }
                break;

            case FindBoth:
                if (mShiftKey && mDeadKey) {
                    return true;
                }
                break;
        }

        return false;
    }

    KeyAreaReset::KeyAreaReset()
        : parent(0)
    {}

    void KeyAreaReset::setKeyParentItem(QGraphicsItem *newParent)
    {
        parent = newParent;
    }

    bool KeyAreaReset::operator()(MImAbstractKey *key)
    {
        if (not key) {
            return false;
        }

        // When used with a parent item, check whether key belongs to that.
        // Otherwise, don't reset key.
        if (parent) {
            const MImKey *item = dynamic_cast<const MImKey *>(key);
            if (item && (item->parentItem() != parent)) {
                return false;
            }
        }

        const bool keyWasReleased = key->touchPointCount() > 0;

        key->resetTouchPointCount();

        if (keyWasReleased) {
            emit keyReleased(key);
        }

        return false;
    }
}
