/* * This file is part of meego-im-framework *
 *
 * Copyright (C) 2011 Nokia Corporation and/or its subsidiary(-ies).
 * All rights reserved.
 * Contact: Nokia Corporation (directui@nokia.com)
 *
 * If you have questions regarding the use of this file, please contact
 * Nokia at directui@nokia.com.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation
 * and appearing in the file LICENSE.LGPL included in the packaging
 * of this file.
 */

#ifndef MIMXERRORTRAP_H
#define MIMXERRORTRAP_H

#include "mimxextension.h"

#include <X11/Xlib.h>

/*! \internal
 * \ingroup maliitserver
 * \brief A helper class to enable trapping of X errors.
 *
 * \warning This class is not thread safe and must be only used in the main UI
 * thread.
 */
class MImXErrorTrap
{
public:
    //! Constructs a MImXErrorTrap object and start traping X errors with the specific
    //! \a majorCode and \a minorCode
    explicit MImXErrorTrap(int majorCode, int minorCode = 0);
    //! Constructs a MImXErrorTrap object and start traping X errors generated by
    //! \a extension with \a minorCode
    explicit MImXErrorTrap(const MImXExtension &extension, int minorCode);
    ~MImXErrorTrap();

    //! Flushes the X ouput buffer when \a sync. Stops trapping for the X error.
    //! Returns the error code for an error which occured or Success.
    int untrap(bool sync = true);

private:
    bool matches(XErrorEvent *e);

    int major_code;
    int minor_code;
    int error_code;
    XErrorHandler old_handler;

    friend int mim_x_error_handler(Display *, XErrorEvent *);
};
//! end_internal

#endif // MIMXERRORTRAP_H
