#include <glib.h>

#define CLIENT_ID "tst"
#define CLIENT_VERSION "1.0"

/**
 * get_auth_string:
 * @password: a password to build the authorization string from
 * @timestamp: a pointer to store the used timestamp.
 *
 * Builds an authorization string based on the password
 * and the current epoch time. The Last.fm authorization string
 * is of the form md5 (md5 (@password) + @timestamp).
 *
 * Returns: a newly allocated string with the authorization md5sum,
 * to be used together with @timestamp.
 **/
static gchar *
get_auth_string (const gchar *password,
		 glong *timestamp)
{
	GTimeVal time_val;
	gchar *auth;
	gchar *md5;

	g_return_val_if_fail (timestamp != NULL, NULL);

	g_get_current_time (&time_val);
	md5 = g_compute_checksum_for_string (G_CHECKSUM_MD5, password, -1);

	auth = g_strdup_printf ("%s%li", md5, time_val.tv_sec);
	g_free (md5);

	*timestamp = time_val.tv_sec;

	md5 = g_compute_checksum_for_string (G_CHECKSUM_MD5, auth, -1);
	g_free (auth);

	return md5;
}

static gboolean
mafw_lastfm_scrobble_handshake (/* MafwLastfmScrobbler *scrobbler, */
				const gchar *username,
				const gchar *passwd)
{
	gchar *auth;
	glong timestamp;
	gchar *handshake_url;

	auth = get_auth_string (passwd, &timestamp);

	handshake_url = g_strdup_printf ("http://post.audioscrobbler.com/?hs=true&p=1.2.1&c=%s&v=%s&u=%s&t=%li&a=%s",
					 CLIENT_ID, CLIENT_VERSION,
					 username,
					 timestamp,
					 auth);

	g_print ("%s\n", handshake_url);

	g_free (handshake_url);
	g_free (auth);

	return TRUE;
}

int
main ()
{
	mafw_lastfm_scrobble_handshake ("csaavedra", "claudianga");
	return 0;
}

