#include "welcomescreen.h"
#include "ui_welcomescreen.h"
#include "mainwindow.h"
#include <QGraphicsScene>
#include <QtGui>

bool gameStarted = false;

QTimer *timer = new QTimer;

WelcomeScreen::WelcomeScreen(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::WelcomeScreen)
{
    ui->setupUi(this);

    ui->lblX->hide();
    ui->spinBoxHeight->hide();
    ui->spinBoxWidth->hide();
    ui->pushButton_2->setEnabled(false);

    ui->lblLogo->setAlignment(Qt::AlignCenter);

}

WelcomeScreen::~WelcomeScreen()
{
    delete ui;
}

void WelcomeScreen::on_pushButton_clicked()
{
    srand(QTime(0,0,0).secsTo(QTime::currentTime()));


    QGraphicsScene *scene = new QGraphicsScene();

    scene->setItemIndexMethod(QGraphicsScene::NoIndex);

    QGraphicsView *view = new QGraphicsView();
    view->setScene(scene);

    MainWindow *w =new MainWindow();

    if (ui->pushButton->text() == "Play")
    {
        switch (ui->comboBox->currentIndex())
        {
        case 0:
            w->createMap(57,27, (bool)ui->checkBox->checkState(),false);
            break;
        case 1:
            w->createMap(101,27, (bool)ui->checkBox->checkState(),false);
            break;
        case 2:
            w->createMap(101,51, (bool)ui->checkBox->checkState(),false);
            break;
        case 3:
            w->createMap(201,201, (bool)ui->checkBox->checkState(),false);
            break;
        case 4:
            w->createMap(ui->spinBoxWidth->value(),ui->spinBoxHeight->value(), (bool)ui->checkBox->checkState(),false);
            break;
        }
    }


    ui->pushButton->setText("Continue");
    ui->pushButton_2->setEnabled(true);

    scene->addItem(w);


    //Enabled before but slows down rendering too much
    //view.setRenderHint(QPainter::Antialiasing);

    view->setCacheMode(QGraphicsView::CacheBackground);
    view->setViewportUpdateMode(QGraphicsView::BoundingRectViewportUpdate);
    view->setDragMode(QGraphicsView::ScrollHandDrag);
    view->show();


    disconnect(timer,SIGNAL(timeout()),scene, SLOT(advance()));
    timer->setInterval(20);
    timer->start();
    connect(timer,SIGNAL(timeout()),scene, SLOT(advance()));

}

void WelcomeScreen::on_comboBox_currentIndexChanged(int index)
{
    if (index == 4)
    {
        ui->lblX->show();
        ui->spinBoxHeight->show();
        ui->spinBoxWidth->show();
    }
    else
    {
        ui->lblX->hide();
        ui->spinBoxHeight->hide();
        ui->spinBoxWidth->hide();
    }
}

void WelcomeScreen::on_pushButton_2_clicked()
{
    srand(QTime(0,0,0).secsTo(QTime::currentTime()));


    QGraphicsScene *scene = new QGraphicsScene();

    scene->setItemIndexMethod(QGraphicsScene::NoIndex);

    QGraphicsView *view = new QGraphicsView();
    view->setScene(scene);

    MainWindow *w =new MainWindow();

    switch (ui->comboBox->currentIndex())
    {
    case 0:
        w->createMap(57,27, (bool)ui->checkBox->checkState(),true);
        break;
    case 1:
        w->createMap(101,27, (bool)ui->checkBox->checkState(),true);
        break;
    case 2:
        w->createMap(101,51, (bool)ui->checkBox->checkState(),true);
        break;
    case 3:
        w->createMap(201,201, (bool)ui->checkBox->checkState(),true);
        break;
    case 4:
        w->createMap(ui->spinBoxWidth->value(),ui->spinBoxHeight->value(), (bool)ui->checkBox->checkState(),true);
        break;
    }

    ui->pushButton->setText("Continue");
    ui->pushButton_2->setEnabled(false);

    scene->addItem(w);


    //Enabled before but slows down rendering too much
    //view.setRenderHint(QPainter::Antialiasing);

    view->setCacheMode(QGraphicsView::CacheBackground);
    view->setViewportUpdateMode(QGraphicsView::BoundingRectViewportUpdate);
    view->setDragMode(QGraphicsView::ScrollHandDrag);
    view->show();

    disconnect(timer,SIGNAL(timeout()),scene, SLOT(advance()));
    timer->setInterval(20);
    timer->start();
    connect(timer,SIGNAL(timeout()),scene, SLOT(advance()));
}
