#include "mainwindow.h"
#include <qmath.h>
#include <QPainter>
#include <QTime>
#include <ctime>
#include <QtEvents>
#include <QtGui>


#include <QFile>
#include <QTextStream>
#include <QStringList>
#include <QGraphicsScene>
#include <QGraphicsView>

#include <QApplication>
#include <QMenuBar>

//For Maze generation
const int MaxX = 999;
const int MaxY = 999;
int xCells = 57;
int yCells = 25;

int totalCells;
#define WALL 1
#define PATH 0

int maze[MaxX][MaxY];

void init_maze(int maze[MaxX][MaxY]);
void maze_generator();
bool wallsIntact(int x, int y);

//Centre on the point when the maze is being played
bool CenterOnPoint = false;

//For collision checking
bool collide(int xpos, int ypos);
float clamp(float x, float a, float b);

//Other random stuff
int xlocation = 18;
int ylocation = 18;
int cellSize = 14;
int cellWH = 14;


//for racing the time
QTime selfTimer;

//for the timer
bool timing = false;
bool finished = true;


MainWindow::MainWindow()
{
}

void MainWindow::createMap(int sizeWidth, int sizeHeight, bool lockScroll, bool newMap)
{
    if (newMap)
    {
        xlocation = 18;
        ylocation = 18;
    }
    //ensure the random generator is random :p
    srand(time(NULL));

    xCells = sizeWidth;
    yCells = sizeHeight;
    CenterOnPoint = lockScroll;

    totalCells = ((xCells-1)/2) * ((yCells-1)/2);




    //make the maze
    init_maze(maze);
    maze_generator();


    //start the timer
    selfTimer.start();

}


//We recieved some goodies from the accelerometer, lets go use them
void MainWindow::UpdateData(int xVal, int yVal, int zVal)
{


    int xSpeed = 0;
    int ySpeed = 0;

    int newX = 0;
    int newY = 0;


    xSpeed = (0-xVal)/200;
    newX = (xlocation) + xSpeed;

//    if (newX < 0)
//        newX = 0;
//    else if (newX > (800 - cellWH))
//        newX = (800 - cellWH);


    ySpeed = (0-yVal)/200;
    newY = (ylocation) + ySpeed;


//    if (newY < 0)
//        newY = 0;
//    else if (newY > (420 -cellWH))
//        newY = 420 -cellWH ;


    if (!collide(newX,newY))
    {
        xlocation = newX;
        ylocation = newY;
    }
    else
    {
        if (abs(xSpeed)< abs(ySpeed))
        {
            if (!collide(xlocation,newY))
            {
                //xlocation = xlocation;
                ylocation = newY;
            }
        }
        else
        {
            if (!collide(newX,ylocation))
            {
                xlocation = newX;
                //ylocation = ylocation;
            }
        }
    }

///////////////////////////////////////Collision with start and finish
    float closestX = clamp(xlocation, 10, 28);
    float closestY = clamp(ylocation, 10, 28);

    // Calculate the distance between the circle's center and this closest point
    float distanceX = xlocation - closestX;
    float distanceY = ylocation - closestY;

    // If the distance is less than the circle's radius, an intersection occurs
    float distanceSquared = (distanceX * distanceX) + (distanceY * distanceY);
    if (distanceSquared > (5 * 5) && (timing == false) && (finished == true))
    {
        finished = false;
        timing = true;
        selfTimer.start();
    }


    closestX = clamp(xlocation, (xCells-2)*14, (xCells-2)*14 + 18);
    closestY = clamp(ylocation, (yCells-2)*14, (yCells-2)*14 + 18);

    // Calculate the distance between the circle's center and this closest point
    distanceX = xlocation - closestX;
    distanceY = ylocation - closestY;

    // If the distance is less than the circle's radius, an intersection occurs
    distanceSquared = (distanceX * distanceX) + (distanceY * distanceY);
    if (distanceSquared < (5 * 5))
    {
        timing = false;
        selfTimer.restart();
    }
//////////////////////////////////////////////////////////////////////

    ballX = xlocation;
    ballY = ylocation;

    update();
}

void MainWindow::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)
{

    setCursor(0);

    //Lets set up the painter object

    painter->setBrush(Qt::blue);
    painter->drawRect(10,10,18,18);

    painter->setBrush(Qt::green);
    painter->drawRect((xCells-2)*14,(yCells-2)*14,14,14);


    //Draw the ball that will move around
    QPoint pnt(xlocation,ylocation);
    //ballRect.setRect(xlocation-5,ylocation-5,10,10);
    painter->setBrush(Qt::red);
    painter->drawEllipse(pnt,5,5);

    //painter.drawImage(ballRect, QImage(":/images/ball.png"));


    //Draw the map
    painter->setBrush(Qt::gray);
    for(int y = 0; y < yCells; y++)
    {
        for(int x = 0; x < xCells; x++)
        {

            if(maze[x][y] == WALL)
            {
                painter->drawRect(x*cellSize,y*cellSize,cellWH,cellWH);
                //wallRect.setRect(x*cellSize, y*cellSize, cellWH, cellWH);
                //painter.drawImage(wallRect,QImage(":/images/wall.png"));
            }
        }
    }
    //painter->end();
    QList<QGraphicsView *> list = scene()->views();
    QGraphicsView *vv = list.at(0);
    if (CenterOnPoint)
        vv->centerOn(pnt);

}

//Collision check
bool collide(int xpos, int ypos)
{
    int r = 5;

    QRect curCell, ball;

    for(int y = 0; y < ((yCells)); y++)
    {
        for(int x = 0; x < ((xCells)); x++)
        {
            if(maze[x][y] == WALL)
            {
//                //Collisions based on circle and square
//                float closestX = clamp(xpos, x*14, x*14+cellWH);
//                float closestY = clamp(ypos, y*14, y*14+cellWH);

//                // Calculate the distance between the circle's center and this closest point
//                float distanceX = xpos - closestX;
//                float distanceY = ypos - closestY;

//                // If the distance is less than the circle's radius, an intersection occurs
//                float distanceSquared = (distanceX * distanceX) + (distanceY * distanceY);
//                if (distanceSquared < (r * r))
//                    return true;


                //Collision based on rectangles
                curCell.setRect(x*14,y*14,cellWH,cellWH);
                ball.setRect(xpos-r,ypos-r,2*r,2*r);


                if((curCell.left() <= ball.right() && curCell.right() >= ball.left()) || (curCell.right() >= ball.left() && curCell.left() <= ball.right()))
                {
                        if(curCell.top() <= ball.bottom() && curCell.bottom() >= ball.top())
                        {
                            return true;
                        }
                }

            }
        }
    }
    return false;
}

//For the collision
float clamp(float x, float a, float b)
{
    return x < a ? a : (x > b ? b : x);
}
//reset the map



//set up the maze. Its set up with every 2 places the cell in question.
//this allows cells to be used as walls and cells to be used as cells
//eg    ###############
//      # # # # # # # #
//      ###############
//      # # # # # # # #
//      ###############
//      # # # # # # # #
//      ###############
// where '#' = wall, " " = cell
void init_maze(int maze[MaxX][MaxY])
{
     for(int y = 0; y < yCells; y++)
     {
         for(int x = 0; x < xCells; x++)
         {
             if((x % 2 == 0) || (y % 2 == 0))
                 maze[x][y] = WALL;
             else
                 maze[x][y] = PATH;
         }
     }
}

void maze_generator()
{
    //Start the maze building in the first cell
    int x = 1;
    int y = 1;
    //So we know how many cells we visited
    int visitedCells = 0;
    //Every run we look for the number of surrounding cells with all walls intact
    int numOfCellsFound = 0;
    //to store the neighbouring x and y locations (for destroying the walls)
    int neighbourX[4];
    int neighbourY[4];
    //All visited cells
    int cellStackX[totalCells];
    int cellStackY[totalCells];
    int cellStackIndex = 0;

    //4 walls around every item (except those on the edges, but no one needs to know about them ;)
    int wallX[4];
    int wallY[4];

    //Initialise first cellstack
    cellStackX[cellStackIndex] = 1;
    cellStackY[cellStackIndex] = 1;

    while (visitedCells < (totalCells-1))
    {
        //No cells found yet
        numOfCellsFound = 0;

        //LEFT
        if ((x-2)> 0 && wallsIntact(x-2,y))
        {
            numOfCellsFound++;
            neighbourX[numOfCellsFound] = x-2;
            neighbourY[numOfCellsFound] = y;

            //Set the wall for later removal if its chosen
            wallX[numOfCellsFound] = x-1;
            wallY[numOfCellsFound] = y;

        }
        //RIGHT
        if ((x+2)<xCells && wallsIntact(x+2, y))
        {
            numOfCellsFound++;
            neighbourX[numOfCellsFound] = x+2;
            neighbourY[numOfCellsFound] = y;

            //Set the wall for later removal if its chosen
            wallX[numOfCellsFound] = x+1;
            wallY[numOfCellsFound] = y;
        }
        //UP
        if ((y-2)> 0 && wallsIntact(x,y-2))
        {
            numOfCellsFound++;
            neighbourX[numOfCellsFound] = x;
            neighbourY[numOfCellsFound] = y-2;

            //Set the wall for later removal if its chosen
            wallX[numOfCellsFound] = x;
            wallY[numOfCellsFound] = y-1;
        }
        //DOWN
        if ((y+2)<yCells && wallsIntact(x, y+2))
        {
            numOfCellsFound++;
            neighbourX[numOfCellsFound] = x;
            neighbourY[numOfCellsFound] = y+2;

            //Set the wall for later removal if its chosen
            wallX[numOfCellsFound] = x;
            wallY[numOfCellsFound] = y+1;
        }

        //We found one or more Cells!!! lets destroy a wall.
        if (numOfCellsFound > 0)
        {
            //Pick a random Cell from the surrounding and add it to the cell stack
            int randomCell = rand() % numOfCellsFound+1;
            x = neighbourX[randomCell];
            y = neighbourY[randomCell];
            //Add one to the index of the cell stack
            cellStackIndex++;
            //change the last cell in the stack to this new random cell
            cellStackX[cellStackIndex] = x;
            cellStackY[cellStackIndex] = y;

            //remove the wall seperating the two points
            maze[wallX[randomCell]][wallY[randomCell]] = PATH;

            //Visited one more cell
            visitedCells++;
        }
        else //None of the surrounding cells were not visited before :(
        {
            x = cellStackX[cellStackIndex];
            y = cellStackY[cellStackIndex];
            cellStackIndex--;
        }

    }

}


//Check the cell has all four walls still in place
bool wallsIntact(int x, int y)
{
    if(maze[x - 1][y]  == WALL
       && maze[x][y - 1] == WALL
       && maze[x][y + 1] == WALL
       && maze[x + 1][y] == WALL
    )
        return true;

    return false;
}


void MainWindow::advance(int step)
{    

    QFile file("/sys/class/i2c-adapter/i2c-3/3-001d/coord");
    if (!file.open(QIODevice::ReadOnly | QIODevice::Text))
    {
        int xi = 1000;
        int yi = 1000;
        int zi = 1000;
        UpdateData(xi,yi,zi);
        return;
    }
    QTextStream in(&file);
    QString data = in.readAll();
    QStringList data_splited = data.split(" ");

    QString x = data_splited[0];
    QString y = data_splited[1];
    QString z = data_splited[2];

    int xi = x.toInt();
    int yi = y.toInt();
    int zi = z.toInt();
    UpdateData(xi,yi,zi);


    if (!step)
        return;



}


QRectF MainWindow::boundingRect() const
{
    return QRectF(0, 0,
                  xCells * cellSize, yCells * cellSize);
}

QPainterPath MainWindow::shape() const
{
    QPainterPath path;
    path.addRect(0, 0,
                 xCells * cellSize, yCells * cellSize);
    return path;
}

//void MainWindow::keyPressEvent(QKeyEvent *event)
//{
//    switch (event->key())
//    {
//    case Qt::Key_Left:
//        UpdateData(-10,0,0);
//        update();
//        break;
//    case Qt::Key_Right:
//        UpdateData(+10,0,0);
//        update();
//        break;
//    case Qt::Key_Up:
//        UpdateData(0,-10,0);
//        update();
//        break;
//    case Qt::Key_Down:
//        UpdateData(0,+10,0);
//        update();
//        break;
//    default:
//        event->ignore();
//    }
//}
