#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QGraphicsItem>
#include <QGraphicsScene>

#include <qwidget.h>
#include <qmenubar.h>


class MainWindow : public QGraphicsItem
{
public:
    MainWindow();

    QRectF boundingRect() const;
    QPainterPath shape() const;
    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget = 0);
    int ballX;
    int ballY;
    void advance(int step);
    void createMap(int sizeWidth, int sizeHeight, bool lockScroll, bool newMap);
    //void keyPressEvent(QKeyEvent *event);


protected:
    void UpdateData(int xVal, int yVal, int zVal);


private:
    QMenuBar *menu;
};

#endif // MAINWINDOW_H
