#include <QFile>
#include <QTextStream>
#include <QTimer>
#include <QStringList>

#include "athread.h"

aThread::aThread(QObject *parent)
    : QThread(parent)
{
}

void aThread::run()
{
    QTimer timer;
    connect(&timer, SIGNAL(timeout()), this, SLOT(updateCoords()));
    timer.start(20); // 50 Hz update rate
    exec();
}

void aThread::updateCoords()
{
     QFile file("/sys/class/i2c-adapter/i2c-3/3-001d/coord");
     if (!file.open(QIODevice::ReadOnly | QIODevice::Text))
         return;
     QTextStream in(&file);
     QString data = in.readAll();
     processCoords(data);
}

void aThread::processCoords(QString &data)
{
    QStringList data_splited = data.split(" ");

    x = data_splited[0];
    y = data_splited[1];
    z = data_splited[2];

    int xi = x.toInt();
    int yi = y.toInt();
    int zi = z.toInt();

    emit deviceOrientation(xi, yi, zi);
}



