#include "mainwindow.h"
#include "ui_mainwindow.h"
#include <qmath.h>
#include <QPainter>
#include <QTime>


//For Maze generation
const int xCells = 57;
const int yCells = 25;
//const int xCells = 11;
//const int yCells = 7;
int totalCells = ((xCells-1)/2) * ((yCells-1)/2);
#define WALL 1
#define PATH 0

void init_maze(int maze[xCells][yCells]);
void maze_generator();
bool wallsIntact(int x, int y);

int maze[xCells][yCells];


//For collision checking
bool collide(int xpos, int ypos);
float clamp(float x, float a, float b);

//Other random stuff
int xlocation = 18;
int ylocation = 18;
int cellSize = 14;
int cellWH = 14;


//for racing the time
QTime selfTimer;

//for the timer
bool timing = false;
bool finished = true;

//To paint the map and objects etc
QPainter painter();

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);

    myThread = new aThread(this);
    connect(myThread, SIGNAL(deviceOrientation(int, int, int)),
            this, SLOT(UpdateData(int, int, int)));
    myThread->start(QThread::NormalPriority);

    //make the maze
    init_maze(maze);
    maze_generator();

    //start the timer
    selfTimer.start();
}

MainWindow::~MainWindow()
{
    delete ui;
}

//We recieved some goodies from the accelerometer, lets go use them
void MainWindow::UpdateData(int xVal, int yVal, int zVal)
{


    int xSpeed = 0;
    int ySpeed = 0;

    int newX = 0;
    int newY = 0;


    xSpeed = (0-xVal)/200;
    newX = (xlocation) + xSpeed;

    if (newX < 0)
        newX = 0;
    else if (newX > (800 - cellWH))
        newX = (800 - cellWH);


    ySpeed = (0-yVal)/200;
    newY = (ylocation) + ySpeed;


    if (newY < 0)
        newY = 0;
    else if (newY > (ui->centralWidget->height() -cellWH))
        newY = ui->centralWidget->height() -cellWH ;


    if (!collide(newX,newY))
    {
        xlocation = newX;
        ylocation = newY;
    }
    else
    {
        if (abs(xSpeed)< abs(ySpeed))
        {
            if (!collide(xlocation,newY))
            {
                //xlocation = xlocation;
                ylocation = newY;
            }
        }
        else
        {
            if (!collide(newX,ylocation))
            {
                xlocation = newX;
                //ylocation = ylocation;
            }
        }
    }

///////////////////////////////////////Collision with start and finish
    float closestX = clamp(xlocation, 10, 28);
    float closestY = clamp(ylocation, 10, 28);

    // Calculate the distance between the circle's center and this closest point
    float distanceX = xlocation - closestX;
    float distanceY = ylocation - closestY;

    // If the distance is less than the circle's radius, an intersection occurs
    float distanceSquared = (distanceX * distanceX) + (distanceY * distanceY);
    if (distanceSquared > (5 * 5) && (timing == false) && (finished == true))
    {
        finished = false;
        timing = true;
        selfTimer.start();
    }


    closestX = clamp(xlocation, (xCells-2)*14-2, (xCells-2)*14-2 + 18);
    closestY = clamp(ylocation, (yCells-2)*14-2, (yCells-2)*14-2 + 18);

    // Calculate the distance between the circle's center and this closest point
    distanceX = xlocation - closestX;
    distanceY = ylocation - closestY;

    // If the distance is less than the circle's radius, an intersection occurs
    distanceSquared = (distanceX * distanceX) + (distanceY * distanceY);
    if (distanceSquared < (5 * 5))
    {
        timing = false;
        selfTimer.restart();
    }
//////////////////////////////////////////////////////////////////////

    update();
}

void MainWindow::paintEvent(QPaintEvent *)
{

    QRect wallRect;
    QRect ballRect;

    //Set the timer
    if (timing)
        ui->lcdNumber->display( selfTimer.elapsed()/1000);

    //Lets set up the painter object
    QPainter painter(this);

    painter.setBrush(Qt::blue);
    painter.drawRect(10,10,18,18);

    painter.setBrush(Qt::green);
    painter.drawRect((xCells-2)*14-2,(yCells-2)*14-2,14,14);


    //Draw the ball that will move around
    QPoint pnt(xlocation,ylocation);
    //ballRect.setRect(xlocation-5,ylocation-5,10,10);
    painter.setBrush(Qt::red);
    painter.drawEllipse(pnt,5,5);
    //painter.drawImage(ballRect, QImage(":/images/ball.png"));


    //Draw the map
    painter.setBrush(Qt::gray);
    for(int y = 0; y < yCells; y++)
    {
        for(int x = 0; x < xCells; x++)
        {

            if(maze[x][y] == WALL)
            {
                painter.drawRect(x*cellSize,y*cellSize,cellWH,cellWH);
                //wallRect.setRect(x*cellSize, y*cellSize, cellWH, cellWH);
                //painter.drawImage(wallRect,QImage(":/images/wall.png"));
            }
        }
    }
}

//Collision check
bool collide(int xpos, int ypos)
{
    int r = 5;

    QRect curCell, ball;

    for(int y = 0; y < ((yCells)); y++)
    {
        for(int x = 0; x < ((xCells)); x++)
        {
            if(maze[x][y] == WALL)
            {
//                //Collisions based on circle and square
//                float closestX = clamp(xpos, x*14, x*14+cellWH);
//                float closestY = clamp(ypos, y*14, y*14+cellWH);

//                // Calculate the distance between the circle's center and this closest point
//                float distanceX = xpos - closestX;
//                float distanceY = ypos - closestY;

//                // If the distance is less than the circle's radius, an intersection occurs
//                float distanceSquared = (distanceX * distanceX) + (distanceY * distanceY);
//                if (distanceSquared < (r * r))
//                    return true;


                //Collision based on rectangles
                curCell.setRect(x*14,y*14,cellWH,cellWH);
                ball.setRect(xpos-r,ypos-r,2*r,2*r);


                if((curCell.left() <= ball.right() && curCell.right() >= ball.left()) || (curCell.right() >= ball.left() && curCell.left() <= ball.right()))
                {
                        if(curCell.top() <= ball.bottom() && curCell.bottom() >= ball.top())
                        {
                            return true;
                        }
                }

            }
        }
    }
    return false;
}

//For the collision
float clamp(float x, float a, float b)
{
    return x < a ? a : (x > b ? b : x);
}
//reset the map
void MainWindow::on_pushButton_clicked()
{
    xlocation = 18;
    ylocation = 18;
    selfTimer.restart();
    finished = true;
    timing = false;
    ui->lcdNumber->display(0);
}
//new map
void MainWindow::on_pushButton_2_clicked()
{
    selfTimer.restart();
    finished = true;
    timing = false;
    ui->lcdNumber->display(0);

    xlocation = 18;
    ylocation = 18;

    init_maze(maze);
    maze_generator();
}



//set up the maze. Its set up with every 2 places the cell in question.
//this allows cells to be used as walls and cells to be used as cells
//eg    ###############
//      # # # # # # # #
//      ###############
//      # # # # # # # #
//      ###############
//      # # # # # # # #
//      ###############
// where '#' = wall, " " = cell
void init_maze(int maze[xCells][yCells])
{
     for(int y = 0; y < yCells; y++)
     {
         for(int x = 0; x < xCells; x++)
         {
             if((x % 2 == 0) || (y % 2 == 0))
                 maze[x][y] = WALL;
             else
                 maze[x][y] = PATH;
         }
     }
}

void maze_generator()
{
    //Start the maze building in the first cell
    int x = 1;
    int y = 1;
    //So we know how many cells we visited
    int visitedCells = 0;
    //Every run we look for the number of surrounding cells with all walls intact
    int numOfCellsFound = 0;
    //to store the neighbouring x and y locations (for destroying the walls)
    int neighbourX[4];
    int neighbourY[4];
    //All visited cells
    int cellStackX[totalCells];
    int cellStackY[totalCells];
    int cellStackIndex = 0;

    //4 walls around every item (except those on the edges, but no one needs to know about them ;)
    int wallX[4];
    int wallY[4];

    //Initialise first cellstack
    cellStackX[cellStackIndex] = 1;
    cellStackY[cellStackIndex] = 1;

    while (visitedCells < (totalCells-1))
    {
        //No cells found yet
        numOfCellsFound = 0;

        //LEFT
        if ((x-2)> 0 && wallsIntact(x-2,y))
        {
            numOfCellsFound++;
            neighbourX[numOfCellsFound] = x-2;
            neighbourY[numOfCellsFound] = y;

            //Set the wall for later removal if its chosen
            wallX[numOfCellsFound] = x-1;
            wallY[numOfCellsFound] = y;

        }
        //RIGHT
        if ((x+2)<xCells && wallsIntact(x+2, y))
        {
            numOfCellsFound++;
            neighbourX[numOfCellsFound] = x+2;
            neighbourY[numOfCellsFound] = y;

            //Set the wall for later removal if its chosen
            wallX[numOfCellsFound] = x+1;
            wallY[numOfCellsFound] = y;
        }
        //UP
        if ((y-2)> 0 && wallsIntact(x,y-2))
        {
            numOfCellsFound++;
            neighbourX[numOfCellsFound] = x;
            neighbourY[numOfCellsFound] = y-2;

            //Set the wall for later removal if its chosen
            wallX[numOfCellsFound] = x;
            wallY[numOfCellsFound] = y-1;
        }
        //DOWN
        if ((y+2)<yCells && wallsIntact(x, y+2))
        {
            numOfCellsFound++;
            neighbourX[numOfCellsFound] = x;
            neighbourY[numOfCellsFound] = y+2;

            //Set the wall for later removal if its chosen
            wallX[numOfCellsFound] = x;
            wallY[numOfCellsFound] = y+1;
        }

        //We found one or more Cells!!! lets destroy a wall.
        if (numOfCellsFound > 0)
        {
            //Pick a random Cell from the surrounding and add it to the cell stack
            int randomCell = rand() % numOfCellsFound+1;
            x = neighbourX[randomCell];
            y = neighbourY[randomCell];
            //Add one to the index of the cell stack
            cellStackIndex++;
            //change the last cell in the stack to this new random cell
            cellStackX[cellStackIndex] = x;
            cellStackY[cellStackIndex] = y;

            //remove the wall seperating the two points
            maze[wallX[randomCell]][wallY[randomCell]] = PATH;

            //Visited one more cell
            visitedCells++;
        }
        else //None of the surrounding cells were not visited before :(
        {
            x = cellStackX[cellStackIndex];
            y = cellStackY[cellStackIndex];
            cellStackIndex--;
        }

    }

}

//Check the cell has all four walls still in place
bool wallsIntact(int x, int y)
{
    if(maze[x - 1][y]  == WALL
       && maze[x][y - 1] == WALL
       && maze[x][y + 1] == WALL
       && maze[x + 1][y] == WALL
    )
        return true;

    return false;
}
