# -*- coding: utf-8 -*-
#!/usr/bin/env python

from distutils.core import setup
import sys
import os

local_src = os.path.join(os.path.dirname(__file__), 'src')
if os.path.exists(local_src):
    sys.path = [local_src] + sys.path

from Maevies.lib import constants

setup(name=constants.APP_NAME.lower(),
      version=constants.APP_VERSION,
      description='A movie advisor for Maemo',
      author='Simón Pena',
      author_email='spenap@gmail.com',
      url='http://gitorious.org/butaca/maevies',
      scripts=['maevies'],
      package_dir={'' : 'src'},
      packages=['Maevies', 'Maevies.lib'],
      data_files=[('share/icons/hicolor/scalable/apps', ['data/maevies.png']),
                  ('share/applications/hildon', ['data/maevies.desktop']),
                  ],
      )
