#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QTimer>
#include <QTime>

#include "SDL/SDL.h"
#include "SDL/SDL_mixer.h"

#include <QtGui>

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow {
    Q_OBJECT
public:
    MainWindow(QWidget *parent = 0);
    ~MainWindow();

#ifdef Q_WS_MAEMO_5
    void setPortrait();
    void setLandscape();
#endif

public slots:
    void onBtnClick();
    void onTimeout();
    void onSliderChanged(int value);
    void onTimeSigChange(int i);
    void onTapClicked();
    void onBtnPlus();
    void onBtnMinus();

protected:
    void changeEvent(QEvent *e);

private:
    Ui::MainWindow *ui;

    QTimer* timer_;

    int bpm_;
    int timesiq1_;
    int timesiq2_;
    bool started_;
    int counter_;

    // Tap tempo stuff
    QTime taptimer_;

    Mix_Chunk *sound_;
    Mix_Chunk *sound2_;
    int channel_;
};

#endif // MAINWINDOW_H
