#include "mainwindow.h"
#include "ui_mainwindow.h"

#include <QSettings>
//#include <QDebug>

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow),
    bpm_(120),
    timesiq1_(4),
    timesiq2_(4),
    started_(false),
    counter_(0),
    sound_(NULL),
    sound2_(NULL),
    channel_(1)
{
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5AutoOrientation, true);
#endif

    ui->setupUi(this);

    timer_ = new QTimer(this);
    taptimer_.start();

    // Time signatures...
    for (int i = 1 ; i < 17 ; ++i) {
        ui->comboTS1->addItem(QString::number(i,10));
        if ( i == 1 || i == 2 || i == 4 || i == 8 ) { //|| i == 16 ) {
            ui->comboTS2->addItem(QString::number(i,10));
        }
    }

    // Load sounds
    sound_ = Mix_LoadWAV("/opt/maetronome/click.wav");
    if(sound_ == NULL) {
        printf("Unable to load WAV file: %s\n", Mix_GetError());
    }
    sound2_ = Mix_LoadWAV("/opt/maetronome/blip.wav");
    if(sound_ == NULL) {
        printf("Unable to load WAV file: %s\n", Mix_GetError());
    }

    // Connects
    connect(ui->action_Quit, SIGNAL(triggered()), this, SLOT(close()));
    connect(ui->horizontalSlider, SIGNAL(valueChanged(int)), this, SLOT(onSliderChanged(int)));
    connect(ui->pushButton, SIGNAL(clicked()), this, SLOT(onBtnClick()));
    connect(ui->btnMinus, SIGNAL(clicked()), this, SLOT(onBtnMinus()));
    connect(ui->btnPlus, SIGNAL(clicked()), this, SLOT(onBtnPlus()));
    connect(timer_, SIGNAL(timeout()), this, SLOT(onTimeout()));
    connect(ui->comboTS1, SIGNAL(currentIndexChanged(int)), this, SLOT(onTimeSigChange(int)));
    connect(ui->comboTS2, SIGNAL(currentIndexChanged(int)), this, SLOT(onTimeSigChange(int)));
    connect(ui->btnTap, SIGNAL(clicked()), this, SLOT(onTapClicked()));


    // Load previous BPM and time signature
    QSettings sett("maetronome/maetronome");
    bool bOK = false;
    bpm_ = sett.value("history/bpm", QVariant(120)).toInt(&bOK);
    timesiq1_ = sett.value("history/timesig1", QVariant(4)).toInt(&bOK);
    timesiq2_ = sett.value("history/timesig2", QVariant(4)).toInt(&bOK);
    ui->actionHigh_pitch_click->setChecked(sett.value("history/highpitch", QVariant(true)).toBool());

    int tmp = 3;
    if ( timesiq2_ < 8 ) {
        tmp = (timesiq2_ / 2);
    }
    ui->comboTS1->setCurrentIndex(timesiq1_ - 1);
    ui->comboTS2->setCurrentIndex(tmp);
    ui->horizontalSlider->setValue(bpm_);


}

MainWindow::~MainWindow()
{
    // Save BPM and time signature
    QSettings sett("maetronome/maetronome");
    sett.setValue("history/bpm", bpm_);
    sett.setValue("history/timesig1", timesiq1_);
    sett.setValue("history/timesig2", timesiq2_);
    sett.setValue("history/highpitch", ui->actionHigh_pitch_click->isChecked());

    // Shutdown SDL
    while(Mix_Playing(channel_) != 0);
    Mix_FreeChunk(sound_);
    Mix_FreeChunk(sound2_);
    Mix_CloseAudio();
    SDL_Quit();

    delete ui;
}

void MainWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

// Start/stop button
void MainWindow::onBtnClick() {
    if ( started_ ) {
        counter_ = 0;
        ui->pushButton->setText("Start");
        started_ = false;
        timer_->stop();
    }
    else {
        ui->pushButton->setText("Stop");

        int interval = (60000 / bpm_) / (timesiq2_ / 4.0);
        timer_->start(interval);
        started_ = true;
    }
}

// Plus button
void MainWindow::onBtnPlus() {
    ui->horizontalSlider->setValue(ui->horizontalSlider->value() + 1);
}

// Minus button
void MainWindow::onBtnMinus() {
    ui->horizontalSlider->setValue(ui->horizontalSlider->value() - 1);
}

// Timer timeout
void MainWindow::onTimeout() {
    //Play our sound file, and capture the channel on which it is played
    Mix_HaltChannel(1);

    if (!counter_ && ui->actionHigh_pitch_click->isChecked())
      channel_ = Mix_PlayChannel(1, sound2_, 0);
    else channel_ = Mix_PlayChannel(1, sound_, 0);

    if(channel_ == -1) {
        printf("Unable to play WAV file: %s\n", Mix_GetError());
    }

    counter_ = (counter_ + 1) % timesiq1_;
}

// BPM Changed
void MainWindow::onSliderChanged(int value) {
    ui->lcdNumber->display(value);
    bpm_ = ui->lcdNumber->intValue();

    if ( started_ ) {
        int interval = (60000 / bpm_) / (timesiq2_ / 4.0);
        timer_->stop();
        timer_->start(interval);
    }
}

// Time signature changed
void MainWindow::onTimeSigChange(int i) {
    bool bOk1, bOk2;
    int ts1 = ui->comboTS1->currentText().toInt(&bOk1, 10);
    int ts2 = ui->comboTS2->currentText().toInt(&bOk2, 10);
    if ( !bOk1 || !bOk2 ) {
        return;
    }

    if (started_ && ts2 != timesiq2_ ) {
        int interval = (60000 / bpm_) / (ts2 / 4.0);
        timer_->stop();
        timer_->start(interval);
    }

    if ( ts1 != timesiq1_ ) timesiq1_ = ts1;
    else if ( ts2 != timesiq2_ ) timesiq2_ = ts2;
    counter_ = 0;
}

// Tap button clicked
void MainWindow::onTapClicked() {
    int elapsed = taptimer_.restart();

    if ( elapsed > 2500 ) {
        return;
    }
    else if ( elapsed > 1500 ) {
        elapsed = 1500;
    }
    else if ( elapsed < 240 ) {
        elapsed = 240;
    }

    int tempo = (int)(60.0 / (elapsed / 1000.0));
    ui->horizontalSlider->setValue(tempo);

}
