#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QTimer>

#include "SDL/SDL.h"
#include "SDL/SDL_mixer.h"

#include <QtGui>

#ifdef Q_WS_MAEMO_5
#include <QtDBus>
#include <QtMaemo5>

#include <mce/mode-names.h>
#include <mce/dbus-names.h>
#endif

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow {
    Q_OBJECT
public:
    MainWindow(QWidget *parent = 0);
    ~MainWindow();

#ifdef Q_WS_MAEMO_5
    void setPortrait();
    void setLandscape();
#endif

public slots:
    void onBtnClick();
    void onTimeout();
    void onSliderChanged(int value);
    void onTimeSigChange(int i);
    void onBtnPlus();
    void onBtnMinus();
#ifdef Q_WS_MAEMO_5
    void orientationChanged(const QString &newOrientation);
#endif

protected:
    void changeEvent(QEvent *e);
#ifdef Q_WS_MAEMO_5
    bool event(QEvent *ev);
#endif

private:
    Ui::MainWindow *ui;

    QTimer* timer_;

    int bpm_;
    int timesiq1_;
    int timesiq2_;
    bool started_;
    int counter_;

    Mix_Chunk *sound_;
    Mix_Chunk *sound2_;
    int channel_;
};

#endif // MAINWINDOW_H
