#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QTimer>

#include "SDL/SDL.h"
#include "SDL/SDL_mixer.h"

#include <QtGui>
#include <QtDBus>
#include <QtMaemo5>

#include <mce/mode-names.h>
#include <mce/dbus-names.h>


namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow {
    Q_OBJECT
public:
    MainWindow(QWidget *parent = 0);
    ~MainWindow();

    void setPortrait();
    void setLandscape();

public slots:
    void onBtnClick();
    void onTimeout();
    void onSliderChanged(int value);
    void onTimeSigChange(int i);
    void orientationChanged(const QString &newOrientation);

protected:
    void changeEvent(QEvent *e);
    bool event(QEvent *ev);

private:
    Ui::MainWindow *ui;

    QTimer* timer_;

    int bpm_;
    int timesiq1_;
    int timesiq2_;
    bool started_;
    int counter_;

    Mix_Chunk *sound_;
    Mix_Chunk *sound2_;
    int channel_;
};

#endif // MAINWINDOW_H
