#include <QtGui/QApplication>

#include <cstdlib>
#include "SDL/SDL.h"
#include "SDL/SDL_mixer.h"

#include "mainwindow.h"

int main(int argc, char *argv[])
{
    //Initialize SDL audio
    if (SDL_Init(SDL_INIT_AUDIO) != 0) {
        printf("Unable to initialize SDL: %s\n", SDL_GetError());
        return 1;
    }

    /********** SDL MIXERILLE ****************/
    int audio_rate = 22050;                 //Frequency of audio playback
    Uint16 audio_format = AUDIO_S16SYS;     //Format of the audio we're playing
    int audio_channels = 2;                 //2 channels = stereo
    int audio_buffers = 4096;               //Size of the audio buffers in memory

    //Initialize SDL_mixer with our chosen audio settings
    if(Mix_OpenAudio(audio_rate, audio_format, audio_channels, audio_buffers) != 0) {
        printf("Unable to initialize audio: %s\n", Mix_GetError());
        exit(1);
    }

    QApplication a(argc, argv);
    MainWindow w;
    w.show();
    return a.exec();
}
