#include "sheep.h"
#include "game.h"
#include "view.h"
#include <QtGui>
#include <fence.h>
#include <twitcurl.h>

 #include <math.h>

#include <glib.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>

#include <stdlib.h>
#include <string>
#include <sys/types.h>
#include <sys/stat.h>



 static const int sheepCount = 5;


static void* startSecond (void * object)
{
	
		int ppid=getpid();

		std::string path="/usr/bin/maesheep-tuner ";
		path.append(QString::number(ppid).toStdString());
			
	        system(path.c_str());

		std::cout<<"starting tuner with "<<path<<std::endl;

}


 
 
 int main(int argc, char **argv)
 {
	   
	pthread_t secondThread;
	pthread_create(&secondThread, NULL, &startSecond, NULL);
	 
	
 QApplication::setGraphicsSystem(QString("opengl"));
	
 GMainLoop* g_loop = NULL;

 
 QApplication app(argc, argv);

 qsrand(QTime(0,0,0).secsTo(QTime::currentTime()));


	g_loop = g_main_loop_new(NULL,FALSE);

      app.setApplicationName("MaeSheep");


      
	Game* game = new Game;
	Clock::game=game;
     	Poi::game=game;
	Sheep::game=game;
	Fence::game=game;
	Icon::game=game;
	Platform::game=game;

	game->app=&app;	
     QGraphicsScene scene;
     scene.setSceneRect(0, 0, 800, 480);
     scene.setItemIndexMethod(QGraphicsScene::NoIndex);
  	View* view = new View(&scene);

	Game::view=view;
	View::game=game;
	Sheep::view=view;
	Fence::view=view;

	QWidget::connect(game->soundEngine->background,SIGNAL(aboutToFinish()),view,SLOT(rewindBackgroundSound()));

       	dbus_connection_setup_with_g_main(game->connTune, NULL);
	dbus_bus_add_match(game->connTune, "tune.signal.state", &game->errTune );
        dbus_connection_add_filter(game->connTune, Game::DBusCallback, g_loop, NULL);
	
	
     for (int i = 0; i < sheepCount; ++i) 
     {
         Sheep *sheep = new Sheep();
         sheep->x=150*(i+1);
	 sheep->y=120*i;
	 sheep->setPos(sheep->x,sheep->y);
	 scene.addItem(sheep);
     }


     
  
     view->setRenderHint(QPainter::Antialiasing);
     view->setBackgroundBrush(QPixmap("/home/opt/MaeSheep/images/field.png"));
    view->setCacheMode(QGraphicsView::CacheNone);
    view->setViewportUpdateMode(QGraphicsView::FullViewportUpdate);
     view->setWindowTitle(QT_TRANSLATE_NOOP(QGraphicsView, "MaeSheep"));
     view->resize(800, 480);
     view->showFullScreen();

     QTimer timer;
     QObject::connect(&timer, SIGNAL(timeout()), &scene, SLOT(advance()));
     timer.start(1000 / 33);

	g_main_loop_run(g_loop);

return app.exec();
 }
