import QtQuick 1.1
import com.nokia.meego 1.0

Rectangle {
  signal getImagePaths;
  signal posX;
  signal changeDir;
  signal getCountImages;
  signal startLoadThumbs;
  signal sendLoadSubfolders;
  signal quit;
  function updateMsg(text, text2) {
    grid.imgPath = text
    grid.fullImgPath = text2
  }
  function setCacheThumbs(value) {
    cacheThumbs = value;
  }
  function setConfig(value) {  
    loadSubfoldersBtn.checked = value;
  }
  function resetImgPos() {
    doubleClickArea.preventStealing = true;
    fullImg.width= imageViewer.width
    fullImg.height = imageViewer.height
    frameFlick.contentWidth = imageViewer.width
    frameFlick.contentHeight = imageViewer.height //, scaleImg.start() 
    fullImgBack.width = imageViewer.width
    fullImgBack.height = imageViewer.height
    frameFlick.returnToBounds();
  
  }
  function loadThumbs() {
      var i=0;
    getCountImages()
    for(i=0; i<grid.countImages ;i++) {
      getImagePaths()
      thumbList.append({"name": grid.imgPath, "colorCode":"pink", "index": i, "sourceThumb":grid.imgPath, "sourceFullImage": grid.fullImgPath})
      if(cacheThumbs.checked) {  
        grid.cacheBuffer+=20//(150/6)
      } 
      else {
        grid.cacheBuffer = 0
      }
    }
    loadBtn.text = grid.count
  }
  function clearGrid() {
    thumbList.clear;
  }
  function updateCountImages(count, dirPath) {
    grid.countImages = count;  
    grid.dirPath = dirPath;
    return count;
  }
  function updateWH(w, h) {
  }
  function changeDirAfter() {
//    loadImagesBtn.enabled = true;
    thumbList.clear();
//    backToGrid.enabled = false;
    loadThumbs();
    animGridCenter.start();
  }
  id: page
  color: "black"
  width: 800//screen.displayWidth
  height: 480//screen.displayHeight
  onWidthChanged: animGridCenter.start(), resetImgPos()
  Item {
    id: imageViewer
    x: grid.x + grid.width
    width: parent.width
    height: parent.height    
    Flickable {
      id: frameFlick
//      width: parent.width-50
//      height: parent.height-50
      contentWidth: fullImg.width
      contentHeight: fullImg.height
      anchors.fill: parent
      
      Rectangle {
        id: fullImgBack
        width: page.width
        height: page.height
        x: grid.x + grid.width
        color: "black"
        Text {
          id: rightText
          anchors.centerIn: parent
          font.pointSize: 29
          text: "Click a thumbnail !"
          font.bold: true
          color: "white"
        }
        Image {
          id: fullImg
//          width: slider.value
  //        height: imageViewer.height
//          sourceSize.width: page.width
    //          sourceSize.height: parent.height
          cache: false
          asynchronous: true
          smooth: false
          property string path: ""
          property int index: 0
          fillMode: Image.PreserveAspectFit
          source: path
          anchors.centerIn: parent
          
        }
      }
      // onFrameFlick
      onMovementStarted: {
        slider.opacity = 0.01
        rotButns.opacity = 0.01
      }
      MouseArea {
        id: doubleClickArea
        anchors.fill: parent
  //      height: parent.height-100
  //      width: parent.width-100
        drag.target: fullImg.width==page.width?fullImgBack:undefined
        drag.axis: Drag.YAxis
        drag.minimumY: -page.height
        drag.maximumY: page.height
        
        preventStealing: true
        onReleased: { 
          if(fullImgBack.y < -page.height/3) { 
//            fullImgBackRestPos.start();
            fullImg.index = fullImg.index+1;
            if(fullImg.index > thumbList.count-1) {
              fullImg.index = 0
            }
            fullImg.path = thumbList.get(fullImg.index).sourceFullImage;
//            fullImg.width = page.width;
//            fullImg.height = page.height;
            rightText.text = "Loading...";  
            resetImgPos();
            fullImgBackUpCenter.start(); 
          }
          else if(fullImgBack.y > page.height/3) { 
//            fullImgBackRestPos.start();
            fullImg.index = fullImg.index-1;
            if(fullImg.index < 0) {
              fullImg.index = thumbList.count-1;
            }
            fullImg.path = thumbList.get(fullImg.index).sourceFullImage;
//            fullImg.width = page.width;
//            fullImg.height = page.height;
            rightText.text = "Loading...";  
            resetImgPos();
            fullImgBackUpCenter.start();
          }
          else {
            fullImgBackCenter.start()
          }
        }
        onDoubleClicked: { 
          doubleClickArea.preventStealing = false;
          fullImg.width = fullImg.width*2.5;
          fullImg.height = fullImg.height*2.5;
//          fullImg.sourceSize.width = 0;
//          fullImg.asynchronous = true;
          fullImgBack.width = fullImg.paintedWidth;
          fullImgBack.height = fullImg.paintedHeight;
          frameFlick.contentWidth = fullImg.paintedWidth;
          frameFlick.contentHeight = fullImg.paintedHeight;
          frameFlick.returnToBounds();
        }
       }
      NumberAnimation { id: fullImgBackCenter; target: fullImgBack; properties: "y"; from: fullImgBack.y; to: 0; duration: 500; easing.type: Easing.OutElastic }
      NumberAnimation { id: fullImgBackUpCenter; target: fullImgBack; properties: "y"; from: -fullImgBack.height; to: 0; duration: 500; easing.type: Easing.OutElastic }
      NumberAnimation { id: fullImgBackCenterDown; target: fullImgBack; properties: "y"; from: 0; to:fullImgBack.height ; duration: 500; easing.type: Easing.OutElastic }
    }
    MouseArea {
      id: back
      x: 0
      y: 50
      height: parent.height
      width: 50
      onReleased: animBack.start() , resetImgPos()
    }
    MouseArea {
      id: minimalize
      x: 0
      y: 0
      height: 50
      width: parent.width
      onReleased: {
        resetImgPos();
      }
    }
    Slider {
      id: slider
      opacity: 0.2
      height: page.height
//      property int startWidth: fullImg.width
//      property int startHeight: fullImg.height 
//      anchors.horizontalCenter: parent.horizontalCenter

      anchors.right: parent.right
      anchors.verticalCenter: parent.verticalCenter
      value: 1
//      valueIndicatorVisible: true
      onValueChanged: {
        slider.opacity = 0.7;
        doubleClickArea.preventStealing = false;
//        rotButns.opacity = 0.7
        fullImg.width = page.width*slider.value;
        fullImg.height = page.height*slider.value;
        fullImgBack.width = fullImg.paintedWidth;
        fullImgBack.height = fullImg.paintedHeight;
        frameFlick.contentWidth = fullImg.paintedWidth;
        frameFlick.contentHeight = fullImg.paintedHeight;
        frameFlick.returnToBounds();
        if(slider.value < 1.2) { resetImgPos(); }
      }
      orientation: 2
      maximumValue: 3
      minimumValue: 1
    }
    ButtonRow {
      id: rotButns
      anchors.bottom: parent.bottom
//      anchors.verticalCenter: parent.verticalCenter
      opacity: 0.2
      exclusive: false
      width: page.width
      Button {
        text: "Back"
        onClicked: {
          animGridCenter.start()
          slider.opacity = 0.7
          rotButns.opacity = 0.7
        }
      }
      Button {
        text: "Rotate left"
        onClicked: {
          rotLeftAnim.start()
          slider.opacity = 0.7
          rotButns.opacity = 0.7
          frameFlick.contentHeight = fullImg.paintedHeight
          frameFlick.contentWidth = fullImg.paintedWidth
        }
      }
      Button {
        text: "Rotate right"
        onClicked: {
          rotRightAnim.start()
          slider.opacity = 0.7
          rotButns.opacity = 0.7
          frameFlick.contentHeight = fullImg.paintedHeight
          frameFlick.contentWidth = fullImg.paintedWidth
        }
      }
      NumberAnimation { id: rotRightAnim; target: fullImg; properties: "rotation"; from: fullImg.rotation; to: fullImg.rotation+90; duration: 500; easing.type: Easing.InOutQuad }
      NumberAnimation { id: rotLeftAnim; target: fullImg; properties: "rotation"; from: fullImg.rotation; to: fullImg.rotation-90; duration: 500; easing.type: Easing.InOutQuad }
    }
    NumberAnimation { id: scaleImg2; target: fullImg; properties: "width"; from: fullImg.width; to: fullImg.width*3; duration: 800; easing.type: Easing.OutElastic }
    
//    NumberAnimation { id: scaleImg; target: fullImg; properties: "height"; from: fullImg.height; to: fullImg.height*3; duration: 800; easing.type: Easing.OutElastic }
    NumberAnimation { id: animBack; target: grid; properties: "x"; from: -page.width; to: 0; duration: 800; easing.type: Easing.OutBounce }
  }

  Rectangle {
    id: optionsBack
    width: page.width
    height: page.height
    x: grid.x - grid.width - 10
    color: "white"
    radius: 20
    MouseArea {
      id: backToGrid
//      width: 50
//      height: page.height
//      x: optionsBack.x + parent.width -50
      anchors.fill: parent
      drag.target: grid
      drag.axis: Drag.XAxis
      drag.minimumX: -grid.width
      drag.maximumX: grid.width
      onReleased: {
        if(grid.x > (page.width/6)*4) { 
          animGridRight.start();
        }//grid.x = -800 }
        else if(grid.x < (page.width/6)*4) { animGridCenter.start() }//grid.x = 0  }
//        else if(grid.x > 150) { animGridRight.start() }
      }
      
//      onReleased: animGridCenter.start()
    }
    Text {
      id: optionsText
      y: 10
//      anchors.centerIn: parent
      anchors.top: parent.top
      anchors.horizontalCenter: parent.horizontalCenter
      font.pointSize: 29
      text: "MaePyGalleryQML"
      font.bold: true
      color: "black"
    }
    Text {
      id: authorText
      y: page.height - 10
//      anchors.centerIn: parent
      anchors.bottom: parent.bottom
      anchors.horizontalCenter: parent.horizontalCenter
      font.pointSize: 10
      text: "Author: Andrzej Machalski"
      font.bold: true
      color: "black"
    }
    Column {
      y: 50
      anchors.centerIn: parent
      spacing: 20
      width: page.width
//      Row {
//        Button {
//          id: loadImagesBtn
//          text: "Load images"
//          //          anchors.centerIn: parent
//          onClicked: loadImagesBtn.enabled = false, loadThumbs(), animGridCenter.start(), addImages.enabled = true, backToGrid.enabled = true   //signal
//        }
//      }
      
      Button {
        id: addImages
        text: "Change directory"
        enabled: true
        anchors.horizontalCenter: parent.horizontalCenter
        width: page.width/2
//          anchors.centerIn: parent
        onClicked: getCountImages(), changeDir()  //signal
      }
      Text {
        text: grid.dirPath
        anchors.horizontalCenter: parent.horizontalCenter
        color: "black"
//          font.pointSize: 24
      }
      Button {
        id: loadSubfoldersBtn
        text: "Load subfolders"
        enabled: true
        checkable: true
        anchors.horizontalCenter: parent.horizontalCenter
        onClicked: {
          sendLoadSubfolders();
          thumbList.clear()
          loadThumbs();
          animGridCenter.start();
        }
      }
      
      Button {
        id: cacheThumbs
        text: "Cache thumbnails"
        anchors.horizontalCenter: parent.horizontalCenter
        checkable: true
        width: page.width/2
        //          anchors.centerIn: parent
        onClicked: {  
          thumbList.clear(); 
          loadThumbs(); 
          animGridCenter.start();
        }
      }
      Text {
        text: "Warrning: takes a lot of memory"
        color: "Black"
        anchors.horizontalCenter: parent.horizontalCenter
//        font.pointSize: 24
      }
      Button {
        text: "Quit"
        anchors.horizontalCenter: parent.horizontalCenter
        onClicked: quit()
      }
    }
    
  }
  Component.onCompleted: startLoadThumbs() //animGridRight.start(), backToGrid.enabled = false
  GridView {
      id: grid
//        cacheBuffer: 0
      width: parent.width
      height: parent.height
      property string imgPath: ""
      property string fullImgPath: ""
      property string dirPath: ""  
      property int op: 1
      property int countImages: 0
      cellHeight: page.height>page.width?page.height/6 : page.height/4
      cellWidth: page.height>page.width?page.width/3 : page.width/6
      onMovementStarted: { if(upperRow.opacity == 1) { upperRowHide.start() } }
      NumberAnimation { id: animGridCenter; target: grid; properties: "x"; from: grid.x; to: 0; easing.type: Easing.OutQuad; duration: 500;}
      NumberAnimation { id: animGridLeft; target: grid; properties: "x"; from: grid.x; to: -grid.width; easing.type: Easing.OutQuad; duration: 500;}
      NumberAnimation { id: animGridRight; target: grid; properties: "x"; from: grid.x; to: grid.width+10; easing.type: Easing.OutQuad; duration: 500;}
      delegate: Item {
          height: grid.height/4
          Column {
              spacing: 5
              Rectangle {
                id: cell
                width: grid.cellWidth-5
                height: grid.cellHeight-5
                color: "white"
//                  radius: 8
                Image {
                    id: img
                    width: grid.cellWidth-10
                    height: grid.cellHeight-10 
                    asynchronous: true
                    source: sourceThumb
                    sourceSize.width: 140
                    sourceSize.height: 140
                    fillMode: Image.PreserveAspectCrop
                    clip: true
                    anchors.centerIn: parent
//                      anchors.fill: parent
                    onStatusChanged: {
                      if (img.status == Image.Ready) { 
                        imgScale.start()
                      }else if(img.status == Image.Error) {
                        img.source = sourceFullImage
//                        imgScale.start()
                      }
                    }
                }
                MouseArea {
                    id: thumbArea
                    width: grid.cellWidth
                    height: grid.cellHeight 
                    drag.target: grid
                    drag.axis: Drag.XAxis
                    drag.minimumX: -grid.width
                    drag.maximumX: grid.width
                    onReleased: 
                    {
                      doubleClickArea.preventStealing = true;
                      resetImgPos();
                      if(upperRow.opacity == 1) { upperRowHide.start() }
                      if(grid.x < -150) { 
                        animGridLeft.start();
                        fullImg.path = sourceFullImage;
                        fullImg.width = page.width;
                        fullImg.height = page.height;
                        fullImg.index = index;
                        slider.value = 1;
                        fullImg.rotation = 0;
                        rightText.text = "Loading...";  
                      }//grid.x = -800 }
                      else if(grid.x < 150 && grid.x > -150) { animGridCenter.start() }//grid.x = 0  }
                      else if(grid.x > 150) { animGridRight.start() }
                    }
     
                    anchors.centerIn: parent
                    onClicked: {
                      doubleClickArea.preventStealing = true;
                      fullImg.path = sourceFullImage;
                      fullImg.index = index;
                      anim.start();
                      fullImg.width = page.width;
                      fullImg.height = page.height;
                      rightText.text = "Loading...";
                      slider.value = 1  
                    }
                    onPressAndHold: {
                      cell.color = "red"
                    }
                    onDoubleClicked: {
                      cell.color = "red"
                    }
                }
                NumberAnimation { id: anim; target: grid; properties: "x"; from: 0; to: -page.width; duration: 1000; easing.type: Easing.OutQuad }
                NumberAnimation { id: animImg; target: imageViewer; properties: "x"; from: imageViewer.width ; to: 0; duration: 1000; easing.type: Easing.OutQuad }
                NumberAnimation { id: imgScale; target: cell; properties: "scale"; from: 0.6; to: 1; duration: 700; easing.type: Easing.OutElastic }
  
              }

          }
      }
      model: ListModel {
          id: thumbList
//            ListElement {
//                name: "Grey"
//                colorCode: "grey"
//                opa: 1
//                sourceThumb: ""
//                sourceFullImage: ""
//            }
      }
    }
    ButtonRow {
      id: upperRow
//      x: grid.x + grid.width/2 - loadBtn.width/2
      x: grid.x
      y: grid.y//(page.y + page.height) - upperRow.height
      exclusive: false
      width: page.width
      Button {
        id: goUpBtn
        text: "Up"
        width: page.width/6
        onClicked: grid.positionViewAtBeginning(), upperRowShow.start()
      }      
      Button {
        id: loadBtn
        text: "Load"
        enabled: true
        width: (page.width/6)*4
        onClicked: {
          animGridRight.start();
          if(upperRow.opacity != 1) { upperRowShow.start() }
        }
      }
      Button {
        id: goDownBtn
        text: "Down"
        width: page.width/6
        onClicked: grid.positionViewAtEnd(), upperRowShow.start()
      }      
      NumberAnimation { id: upperRowHide; target: upperRow; properties: "opacity"; from: 1; to: 0.01; duration: 700; } 
      NumberAnimation { id: upperRowShow; target: upperRow; properties: "opacity"; from: 0.01; to: 1; duration: 700; } 
   }
    
//    Button {
//      id: btn
//      x: 100
//      y:0
//      text: "Test Button"
//      onClicked: btn.text = "pressed"
//    }
    
states: [ State {
  name: "move"
  PropertyChanges { target: grid; x: -page.width }
  }
]
transitions: [
  Transition {
    NumberAnimation { id: anim; target: grid; properties: "x"; from: 0; to: -page.width; duration: 1000; easing.type: Easing.InBounce }
}  
]

}
