#!/usr/bin/env python

import sys
from PySide.QtCore import QThread, QObject, QEvent, Property, Signal, QUrl, QRect, QTimer, QCoreApplication, Qt, QSize
from PySide.QtGui import QWidget, QMessageBox, QApplication, QFileDialog, QInputDialog, QSizePolicy, QIcon, QMainWindow
import os, md5, math
from PySide.QtDeclarative import QDeclarativeView
import glob
from ctypes import *
import dbus
import osso
import dbus.service
import dbus.mainloop.glib

class myDBus(dbus.service.Object):  ############ DBus connection class ######
 def __init__(self, b, object_path="/"):
   dbus.service.Object.__init__(self, b, object_path)

 @dbus.service.signal('com.nokia.hildon_desktop')
 def exit_app_view(self, message):
  #wyslanie komunikatu exit_app_view do hildon_desktop 
  pass

class Thread(QThread):  #klasa watku od usuwania zdjec
  def __init__(self, parent=None):
    super(Thread, self).__init__()
    self.parent = parent
  def run(self):
    if self.parent.pix != None:
      del self.parent.pix
    self.parent.deleteSelected()

class LoadPixThread(QThread):
  def __init__(self, parent=None):
    super(LoadPixThread, self).__init__()
    self.parent = parent
    self.reader = QImageReader()
#    self.reader.setScaledSize(QSize(800,480))
  def run(self):
    self.reader.setFileName(self.parent.licz[self.parent.index])
    self.parent.pix = self.reader.read()
    print "loaded"
    
class Main(QMainWindow): ################## Main Class ##################
  dbus = myDBus
  loop = None
  licz = [] 
  pathList = [] 
  miniatures = None
  pix = None
  laySpacing = 10
  size = 6
  dirPix = "/home/user/MyDocs/DCIM" #"/home/user/MyDocs/DCIM"
  localDir = os.getcwd()
  adjustedHeight = 0
  
  def __init__(self, size, parent=None):
    super(Main, self).__init__()
    self.setAttribute(Qt.WA_Maemo5AutoOrientation)
    
    self.osso_c = osso.Context("maepygalleryqml", "0.1.1", False)
    dbus.mainloop.glib.DBusGMainLoop(set_as_default=True)
    self.dbus = myDBus(dbus.SessionBus())
    self.initUi()
    QApplication.desktop().resized.connect(self.emitDesktopWH)  #odbieranie sygnalu zmienienia rozmiarow okna
    
#  sygnaly i petla ladujaca zdjecia
  sig = Signal(str, str)
  sigDesktopWidthHeight = Signal(int, int)
  i = 0
  def emitSig(self):
    if self.i > len(self.miniaturki)-1:
      self.i = 0
      self.sig.emit("0", "0")
      return
    thumb = self.miniaturki[self.i]
    fullImg = self.listForSum[self.i]
    self.sig.emit(thumb, fullImg)
    self.i+=1
  def emitDesktopWH(self):
    self.sigDesktopWidthHeight.emit(QApplication.desktop().width(), QApplication.desktop().height())

      
  def initUi(self):
    # ustawienie dla przypadku obkrecenia telefonem podczas ladowania zdjec
    # stwarzalo to bledy, zablokowanie sygnalow podczas ladowania
    QApplication.desktop().blockSignals(True)
    if self.miniatures != None: #usuwanie altualnych miniatur, wywolywane jesli user zmieni katalog
      del self.miniatures[:]

    os.chdir(self.dirPix)
    if len(self.licz) != 0:
      del self.licz[:]
      
#    self.licz = glob.glob(self.dirPix+"/*.jpg")
#    templ = glob.glob(self.dirPix+"/*.jpeg")
    li = os.listdir(os.getcwd())
    for i in range(len(li)):
      if li[i].endswith("jpg") or li[i].endswith("jpeg") or li[i].endswith("JPG") or li[i].endswith("JPEG") or li[i].endswith("BMP") or li[i].endswith("PNG") or li[i].endswith("png") or li[i].endswith("bmp"):
        self.licz.append(li[i])
        
    QApplication.processEvents()
    text = "Loading "+str(len(self.licz))+" images"
    self.setWindowTitle(text)
       
    self.licz.sort()
    #tworzenie listy do sprawdzania sumy md5
    self.listForSum = range(len(self.licz))
    for i in range(len(self.licz)):
      self.listForSum[i] = "file://"+ self.dirPix+"/" + self.licz[i]
    
    self.thumbList = os.listdir("/home/user/.thumbnails/cropped")
    la = os.listdir("/home/user/.thumbnails/normal")
    #usuniecie koncowki .jpegz listy
    for i in range(len(self.thumbList)):
      self.thumbList[i] = self.thumbList[i][:-5]
#    print self.thumbList
    
    #tworzenie listy ze sciezkami do miniaturek zdjec ktore sa w wybranym katalogu
    self.miniaturki = range(len(self.licz))
    for i in range(len(self.licz)):
      a = md5.new(self.listForSum[i]).hexdigest() #suma kontrolna
#      print a
      if a in self.thumbList:
#        print str(a)+".jpeg"
        self.miniaturki[i] = (str(a)+".jpeg")
      else:
        print "no thumbnail for ", self.listForSum[i], self.licz[i]
        self.miniaturki[i] = (str(a)+".jpeg")
#    print self.miniaturki
    os.chdir("/home/user/.thumbnails/cropped")
 
    for i in range(len(self.miniaturki)):
      self.miniaturki[i] = "/home/user/.thumbnails/cropped" + "/" + self.miniaturki[i]
      #    print self.thumbList

    if len(self.licz) == 0:  # there is no jpg's in dir
      self.box = QtMaemo5.QMaemo5InformationBox()
      self.box.information(self, "<br><b>No pictures in directory<b><br>", 10000)
      self.box.show()
      self.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, 0)
      return
      
    self.miniatures = range(len(self.miniaturki))#len(self.licz))
    self.pathList = range(len(self.miniaturki))    
    
if __name__ == '__main__':  
  app = QApplication(sys.argv)
  app.setApplicationName("MaePyGallery")
  app.setDoubleClickInterval(300)
  mai = Main(4)
  os.chdir(mai.localDir)
  view = QDeclarativeView()
  view.setSource(QUrl.fromLocalFile('viewGrid.qml'))
  root = view.rootObject()
  view.setAttribute(Qt.WA_Maemo5AutoOrientation)
  view.setResizeMode(QDeclarativeView().SizeRootObjectToView)
  
  root.getJakis.connect(mai.emitSig)
  root.posX.connect(mai.emitDesktopWH)
  mai.sig.connect(root.updateMsg)
  mai.sigDesktopWidthHeight.connect(root.updateWH)

  view.showFullScreen()
  sys.exit(app.exec_())
