import QtQuick 1.1
import com.nokia.meego 1.0

Rectangle {
  signal getJakis;
  signal posX;
  function updateMsg(text, text2) {
    grid.imgPath = text
    grid.fullImgPath = text2
  }
  function updateWH(w, h) {
  }
  id: page
  color: "black"
  width: 800//screen.displayWidth
  height: 480//screen.displayHeight
  Item {
    id: imageViewer
    x: grid.x + grid.width
    width: parent.width
    height: parent.height    
    Flickable {
      id: frameFlick
//      width: parent.width-50
//      height: parent.height-50
      contentWidth: fullImg.width
      contentHeight: fullImg.height
//      onDoubleClicked: fullImgBack.scale = 3, scaleImg.start()
//      viewportWidth: fullImg.width; viewportHeight: fullImg.height;
//      anchors.centerIn: parent
      anchors.fill: parent
      Rectangle {
        id: fullImgBack
        width: page.width
        height: page.height
        x: grid.x + grid.width
        color: "black"
        Text {
          id: rightText
          anchors.centerIn: parent
          font.pointSize: 29
          text: "Click a thumbnail !"
          font.bold: true
          color: "white"
        }
        Image {
          id: fullImg
//          width: slider.value
  //        height: imageViewer.height
    //          sourceSize.width: parent.width
    //          sourceSize.height: parent.height
          cache: false
          asynchronous: true
          smooth: false
          property string path: ""
          fillMode: Image.PreserveAspectFit
          source: path
          anchors.centerIn: parent
          
        }
      }
      // onFrameFlick
      onMovementStarted: {
        slider.opacity = 0.01
        rotButns.opacity = 0.01
      }
      MouseArea {
        id: doubleClickArea
        anchors.fill: parent
  //      height: parent.height-100
  //      width: parent.width-100
//        drag.target: fullImgBack
//        drag.axis: Drag.YAxis
//        drag.minimumY: -page.height
//        drag.maximumY: page.height
        
        preventStealing: false
        onReleased: { 
          if(fullImgBack.y < -page.height/2) { 
            grid.moveCurrentIndexLeft();
            mouse.accepted = false;
            fullImgBackRestPos.start();
//            fullImg.path = grid.currentItem.sourceFullImage;
//            anim.start();
            fullImg.width = page.width;
            fullImg.height = page.height;
            rightText.text = "Loading...";  
           
          }
          fullImgBackRestPos.start();
        }
        onDoubleClicked: { 
          fullImg.width = fullImg.width*2.5;
          fullImg.height = fullImg.height*2.5;
          fullImgBack.width = fullImg.paintedWidth;
          fullImgBack.height = fullImg.paintedHeight;
          frameFlick.contentWidth = fullImg.paintedWidth;
          frameFlick.contentHeight = fullImg.paintedHeight;
          frameFlick.returnToBounds();
        }
       }
       
      NumberAnimation { id: fullImgBackRestPos; target: fullImgBack; properties: "y"; from: fullImgBack.y; to: 0; duration: 700; easing.type: Easing.OutElastic }
    }
    MouseArea {
      id: back
      x: 0
      y: 50
      height: parent.height
      width: 50
      onReleased: animBack.start() , fullImg.scale = 1
    }
    MouseArea {
      id: minimalize
      x: 0
      y: 0
      height: 50
      width: parent.width
      onReleased: {
        fullImg.width= imageViewer.width
        fullImg.height = imageViewer.height
        frameFlick.contentWidth = imageViewer.width
        frameFlick.contentHeight = imageViewer.height //, scaleImg.start() 
        fullImgBack.width = imageViewer.width
        fullImgBack.height = imageViewer.height
        frameFlick.returnToBounds();
      }
    }
    Slider {
      id: slider
      opacity: 0.2
      height: page.height
//      property int startWidth: fullImg.width
//      property int startHeight: fullImg.height 
//      anchors.horizontalCenter: parent.horizontalCenter

      anchors.right: parent.right
      anchors.verticalCenter: parent.verticalCenter
      value: 1
//      valueIndicatorVisible: true
      onValueChanged: {
        slider.opacity = 0.7
        rotButns.opacity = 0.7
        fullImg.width = page.width*slider.value;
        fullImg.height = page.height*slider.value;
        fullImgBack.width = fullImg.paintedWidth;
        fullImgBack.height = fullImg.paintedHeight;
        frameFlick.contentWidth = fullImg.paintedWidth;
        frameFlick.contentHeight = fullImg.paintedHeight;
      }
      orientation: 2
      maximumValue: 3
      minimumValue: 1
    }
    ButtonRow {
      id: rotButns
      anchors.bottom: parent.bottom
      anchors.horizontalCenter: parent.horizontalCenter
      opacity: 0.2
      exclusive: false
      width: page.width
      Button {
        text: "-90"
        onClicked: {
          rotLeftAnim.start()
          slider.opacity = 0.7
          rotButns.opacity = 0.7
          frameFlick.contentHeight = fullImg.paintedHeight
          frameFlick.contentWidth = fullImg.paintedWidth
        }
      }
      Button {
        text: "+90"
        onClicked: {
          rotRightAnim.start()
          slider.opacity = 0.7
          rotButns.opacity = 0.7
          frameFlick.contentHeight = fullImg.paintedHeight
          frameFlick.contentWidth = fullImg.paintedWidth
        }
      }
      NumberAnimation { id: rotRightAnim; target: fullImg; properties: "rotation"; from: fullImg.rotation; to: fullImg.rotation+90; duration: 500; easing.type: Easing.InOutQuad }
      NumberAnimation { id: rotLeftAnim; target: fullImg; properties: "rotation"; from: fullImg.rotation; to: fullImg.rotation-90; duration: 500; easing.type: Easing.InOutQuad }
    }
    NumberAnimation { id: scaleImg2; target: fullImg; properties: "width"; from: fullImg.width; to: fullImg.width*3; duration: 800; easing.type: Easing.OutElastic }
    
//    NumberAnimation { id: scaleImg; target: fullImg; properties: "height"; from: fullImg.height; to: fullImg.height*3; duration: 800; easing.type: Easing.OutElastic }
    NumberAnimation { id: animBack; target: grid; properties: "x"; from: -page.width; to: 0; duration: 800; easing.type: Easing.OutBounce }
  }

  GridView {
        id: grid
        x: 5
        y: 5
//        cacheBuffer: 0
        width: parent.width
        height: parent.height
        property string imgPath: ""
        property string fullImgPath: ""  
        property int op: 1
        cellHeight: page.height>page.width?page.height/6 : page.height/4
        cellWidth: page.height>page.width?page.width/3 : page.width/6
//        MouseArea {
//          id: gridArea
//          anchors.fill: parent
//           }
        NumberAnimation { id: animGridCenter; target: grid; properties: "x"; from: grid.x; to: 5; easing.type: Easing.OutQuad; duration: 500;}
        NumberAnimation { id: animGridLeft; target: grid; properties: "x"; from: grid.x; to: -grid.width; easing.type: Easing.OutQuad; duration: 500;}
        delegate: Item {
            height: grid.height/4
            Column {
                spacing: 5
                Rectangle {
                  id: cell
                  width: grid.cellWidth-5
                  height: grid.cellHeight-5
                  color: "white"
//                  radius: 8
                  Image {
                      id: img
                      width: grid.cellWidth-10
                      height: grid.cellHeight-10 
                      asynchronous: true
                      source: sourceThumb
                      sourceSize.width: 140
                      sourceSize.height: 140
                      fillMode: Image.PreserveAspectCrop
                      clip: true
                      anchors.centerIn: parent
//                      anchors.fill: parent
                      onStatusChanged: {if (img.status == Image.Ready){ imgScale.start()}}
                  }
                  MouseArea {
                      id: thumbArea
                      width: grid.cellWidth
                      height: grid.cellHeight 
                      drag.target: grid
                      drag.axis: Drag.XAxis
                      drag.minimumX: -grid.width
                      drag.maximumX: grid.width
                      onReleased: 
                      {
//                        animGrid.start()
                        if(grid.x < -150) { 
                          animGridLeft.start();
                          fullImg.path = sourceFullImage;
//                          anim.start();
                          fullImg.width = page.width;
                          fullImg.height = page.height;
                          slider.value = 1;
                          fullImg.rotation = 0;
                          fullImg.rotation = 0;
                          rightText.text = "Loading...";  
                      ;
                        }//grid.x = -800 }
                        else if(grid.x > -300) { animGridCenter.start() }//grid.x = 0  }
                      }
       
                      anchors.centerIn: parent
                      onClicked: {
                        fullImg.path = sourceFullImage;
                        anim.start();
                        fullImg.width = page.width;
                        fullImg.height = page.height;
                        rightText.text = "Loading...";
                        slider.value = 1  
                      }
                      onPressAndHold: {
                        cell.color = "red"
                      }
                  }
                  NumberAnimation { id: anim; target: grid; properties: "x"; from: 0; to: -page.width; duration: 800; easing.type: Easing.OutQuad }
                  NumberAnimation { id: animImg; target: imageViewer; properties: "x"; from: imageViewer.width ; to: 0; duration: 1000; easing.type: Easing.OutQuad }
                  NumberAnimation { id: imgScale; target: cell; properties: "scale"; from: 0.6; to: 1; duration: 700; easing.type: Easing.OutElastic }
    
                }

            }
        }
        model: ListModel {
            id: list
            ListElement {
                name: "Grey"
                colorCode: "grey"
                opa: 1
                sourceThumb: ""
                sourceFullImage: ""
            }
        }
    }
                
    Row {
      id: upperRow
//      x: grid.x + grid.width/2 - loadBtn.width/2
      x: grid.x
      y: 0
      width: page.width
      Button {
        id: goUpBtn
        text: "Up"
        width: page.width/6
        onClicked: grid.positionViewAtBeginning()
      }      
      Button {
        id: loadBtn
        text: "Load"
        width: (page.width/6)*4
        onClicked: {var i=0;
              screen.allowedOrientations = Screen.Portrait;
              for(i=0; grid.imgPath != "0" ;i++) {
                getJakis()
                list.append({"name": grid.imgPath, "colorCode":"pink", "opa": 1, "sourceThumb":grid.imgPath, "sourceFullImage": grid.fullImgPath})
  //              grid.cacheBuffer+=20//(150/6)
                loadBtn.text = "Loaded " + i 
              }
            }
      }
      Button {
        id: goDownBtn
        text: "Down"
        width: page.width/6
        onClicked: grid.positionViewAtEnd()
      }      
    }
//    Button {
//      id: btn
//      x: 100
//      y:0
//      text: "Test Button"
//      onClicked: btn.text = "pressed"
//    }
    
states: [ State {
  name: "move"
  PropertyChanges { target: grid; x: -page.width }
  }
]
transitions: [
  Transition {
    NumberAnimation { id: anim; target: grid; properties: "x"; from: 0; to: -page.width; duration: 1000; easing.type: Easing.InBounce }
}  
]

}
