#include <cairo.h>
#include <pango/pangocairo.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <sqlite3.h>
#include <string.h>
#include <strings.h>

#include "maenotify.h"


gchar *
get_counters(int event_type, int is_read, long st, long et)
{
	g_print("get counters\n");
	sqlite3 *db;
	int rc;
	sqlite3_stmt *res_stmt = NULL;
	gchar *ret;
	ret = NULL;

	rc = sqlite3_open(EVENTS_DB, &db);
	if ( rc ) sqlite3_close(db);

	if ( SQLITE_OK == sqlite3_prepare(db, g_strdup_printf("select remote_name, E.remote_uid, datetime(start_time,'unixepoch') start_time from Events as E, EventTypes ET, Remotes as R where ET.name='RTCOM_EL_EVENTTYPE_CALL_INBOUND' and E.event_type_id=%d and E.is_read=%d and R.remote_uid=E.remote_uid and E.local_uid=R.local_uid and E.start_time between %ld and %ld order by start_time desc limit 3",event_type,is_read,st,et),-1, &res_stmt, NULL) ) {
	       	while ( SQLITE_ROW == sqlite3_step(res_stmt) ) {
			ret = g_strdup_printf("%s@<b>%s</b>\n<span size=\"xx-small\">%s</span>\n",ret,( sqlite3_column_text(res_stmt, 0) != NULL ) ? sqlite3_column_text(res_stmt, 0) : sqlite3_column_text(res_stmt, 1),sqlite3_column_text(res_stmt, 2));
		}
	}  else g_print("query fails\n");
	sqlite3_finalize(res_stmt);
	sqlite3_close(db);


	return (gchar *)ret;
	
}

long
get_timestamp(int w)
{
	time_t t;
	struct tm *timeinfo;
	time(&t);
	timeinfo = localtime(&t);
	
	if ( w == 0 ) { //start time
		timeinfo->tm_hour = 00;
		timeinfo->tm_min = 00;
		timeinfo->tm_sec = 00;
	} else { //end time
		timeinfo->tm_hour = 23;
		timeinfo->tm_min = 59;
		timeinfo->tm_sec = 59;
	}

	return (long)mktime(timeinfo);
}
		    
		    
	

void
restore_info()
{
	g_print("restoring...\n");
	current_lock = FALSE;
	//wrong way
	system("cp /home/user/.maenotify/lockslider.png /etc/hildon/theme/backgrounds/lockslider.png");
}
void
update_info()
{
	gchar		*sms_count;
	gchar		*calls_count;
	long		start_time;
	long		end_time;

	start_time = get_timestamp(0);
	end_time = get_timestamp(1);
	sms_count = g_strdup(get_counters(7,0,start_time,end_time));
	calls_count = g_strdup(get_counters(3,0,start_time,end_time));

	if ( g_strcmp0(current_lock,"locked") == 0 || ( sms_count != NULL && calls_count != NULL ) ) {
	cairo_surface_t *base;
	cairo_t         *cr;
	cairo_status_t   result;
	


	base = cairo_image_surface_create_from_png ( "/home/user/.maenotify/lockslider.png" ); //"/usr/share/themes/alpha/backgrounds/lockslider.png" );

	cr = cairo_create (base);
	cairo_move_to (cr, 10.0, 10.0);

	
	layout = pango_cairo_create_layout (cr);
	pango_layout_set_font_description (layout, desc);

	int bottom=430;
	

	if ( calls_count != NULL ) {
		gchar **c;
		
		c = g_strsplit(calls_count,"@",-1);
		int i;
		for (i=1; c[i] ;i++)
		{
			gdk_cairo_set_source_pixbuf(cr,cpixbuf, 5.0, bottom);
			cairo_paint_with_alpha (cr, 0.0);
			cairo_paint(cr);
			pango_layout_set_markup (layout, c[i], -1);
			cairo_set_source_rgb (cr, 1.0, 1.0, 1.0);
			cairo_move_to (cr, 55.0, bottom);
			bottom=bottom-50;
			pango_cairo_show_layout (cr, layout);
		}
	}

	pango_layout_set_justify ( layout, TRUE );
	pango_layout_set_alignment ( layout, PANGO_ALIGN_RIGHT );

	bottom=430;
	if ( sms_count != NULL ) {
	
		gchar **s;
		
		s = g_strsplit(sms_count,"@",-1);
		int i;
		for (i=1; s[i] ;i++)
		{
			gdk_cairo_set_source_pixbuf(cr,spixbuf, 750.0, bottom);
			cairo_paint_with_alpha (cr, 0.0);
			cairo_paint(cr);
			pango_layout_set_markup (layout, s[i], -1);
			cairo_set_source_rgb (cr, 1.0, 1.0, 1.0);
			cairo_move_to (cr, 600, bottom);
			bottom=bottom-50;
			pango_cairo_show_layout (cr, layout);
		}
	}

	result = cairo_surface_write_to_png (base, "/etc/hildon/theme/backgrounds/lockslider.png");
	
	if ( result == CAIRO_STATUS_SUCCESS ) {
		
		g_print("result ok\n");
	} else {
		g_print("result fails\n");
    	}
	g_object_unref(layout);
	cairo_surface_destroy(base);
	cairo_destroy(cr);
   } else system("cp /home/user/.maenotify/lockslider.png /etc/hildon/theme/backgrounds/lockslider.png");
	
}
