#include "ScrollArea.h"
#include "Viewfinder.h"
#include "ThumbnailView.h"
#include "CameraThread.h"
from PyQt4 import QtCore, QtGui

class ScrollArea(QtGui.QWidget):
    def __init__(self, parent=None):
        super(ScrollArea, self).__init__(parent)
        self.childWidgets = []
        self.contents = QtGui.QWidget(self)
        self.current = 0
        self.old = 0
        self.dragging = None
    # Make an self.animation that moves the scrollArea up and down
        self.animation = QtCore.QPropertyAnimation(self.contents, "geometry", self)
        QtCore.QObject.connect(self.animation, QtCore.SIGNAL("finished()"),self.animationFinished)



    def jumpTo(self,idx) :
    # Can't jump while being dragged. That pins the widget to the user's finger.    
        if self.dragging == self:
            return
        if idx < 0:
            self.jumpTo(0)
        if idx >= self.childWidgets.size():
            self.jumpTo(self.childWidgets.size()-1)
        w = self.childWidgets[idx]
        self.contents.setGeometry(-w.x(), -w.y(), self.contents.width(), self.contents.height())
        self.old = self.current
        self.current = idx


    def jumpTo(self,w):
        for i in range(len(self.childWidgets)):
            if self.childWidgets[i] == w:
                self.jumpTo(i)
                return
        
    
        print("Error: Asked to jump to a non-child widget\n")


    def animationFinished(self):
        self.emit(QtCore.SIGNAL("slidTo(int,int)"), self.current,self.old)
        self.emit(QtCore.SIGNAL("slidTo(QWidget *)"), self.childWidgets[self.current])


    def slideTo(self,idx):
    # Can't slide while being dragged. That pins the widget to the user's finger.
        if self.dragging == self:
            return
        if idx < 0:
            self.slideTo(0)
        if idx >= len(self.childWidgets):
            self.slideTo(len(self.childWidgets)-1)
        w = self.childWidgets[idx]
        self.old = self.current
        self.current = idx
        self.animation.setDuration(250)
        self.animation.setEasingCurve(QtCore.Qt.QEasingCurve.InOutQuad)
        self.animation.setStartValue(self.contents.geometry())
        self.animation.setEndValue(QtGui.QRect(-w.x(), -w.y(), self.contents.width(), self.contents.height()))
        self.animation.start()


    def slideTo(self,w):
        for i in range(len(self.childWidgets)):
            if self.childWidgets[i] == w:
                self.slideTo(i)
                return




    def addWidget(self,w):
#        print w.geometry()
        w.setParent(self.contents)
        w.setGeometry(0, len(self.childWidgets)*self.height(), self.width(), self.height())
        self.childWidgets.append(w)
        self.contents.setGeometry(0, -self.current*self.height(), self.width(), self.height()*len(self.childWidgets))
        w.show()


#void HScrollArea::addWidget(QWidget *w) {
#    w.setParent(self.contents)
#    w.setGeometry(self.childWidgets.size()*width(), 0, width(), height())
#    self.childWidgets.push_back(w);    
#    self.contents.setGeometry(-self.current*width(), 0, width()*self.childWidgets.size(), height())
#}

    def mousePressEvent(self,ev):
    #printf("scroll area press\n")
    #ev.ignore(); return
        self.mouseAnchor = ev.globalPos()
        ev.ignore()



    def mouseReleaseEvent(self, ev):
    #printf("scroll area release\n")
    #ev.ignore(); return
#        print "released"
        if self.dragging == self:
            dy = ev.globalY() - self.filteredMouseAnchor.y()
            
#            print 'ev.globalY()', ev.globalY()
#            print 'self.filteredMouseAnchor.y()', self.filteredMouseAnchor.y()
#            print 'dy', dy

            # snap according to whether the swipe was up or down
            self.animation.setStartValue(self.contents.geometry())
#            print 'self.contents.y()', self.contents.y()
            delta = 0
            if dy > 3 and self.current > 0 and self.contents.y() > -self.height()*self.current:
                delta = -1
            elif dy < -3 and self.current < len(self.childWidgets)  and self.contents.y() < -self.height()*self.current:
                delta = 1
            elif abs(dy) < 3 :
                # snap to closest
                dUp   = abs(self.contents.y() + self.height()*(self.current-1))
#                print "dUp" , dUp
                dHere = abs(self.contents.y() + self.height()*self.current)
#                print "dHere", dHere
                dDown = abs(self.contents.y() + self.height()*(self.current+1))
#                print 'dDown', dDown
                if dUp < dHere and dUp < dDown:
                    delta = -1
                elif dDown < dHere :
                    delta = 1
                
                
            
#            print 'current avant', self.current
            self.old = self.current
            self.current += delta
#            print 'current apres', self.current
            self.animation.setEndValue(QtCore.QRect(self.contents.x(), -self.current*self.height(),self.contents.width(), self.contents. height()))
            self.animation.setDuration(100)
            self.animation.setEasingCurve(QtCore.QEasingCurve.OutQuad)
            self.animation.start()
            self.dragging = None
        else:
            ev.ignore()





    def mouseMoveEvent(self,ev):
    #printf("scroll area mouse move event\n")
    #ev.ignore(); return
        dx = ev.globalX() - self.mouseAnchor.x()
        dy = ev.globalY() - self.mouseAnchor.y()
    
        if abs(dy) > abs(dx) and abs(dy) > 40 and self.dragging == None : 
            self.dragging = self
            self.filteredMouseAnchor = self.mouseAnchor
        elif self.dragging != self :
            ev.ignore()
            return
        
    
        if self.dragging == self :
            # stop any self.animation
            self.animation.stop()
    
            newY = self.contents.y()+dy
            if newY > 0:
                newY = 0
            if newY < self.height()-self.contents.height():
                newY = self.height()-self.contents.height()
            self.contents.setGeometry(self.contents.x(), newY, self.contents.width(), self.contents.height())
            self.mouseAnchor = ev.globalPos()
            self.filteredMouseAnchor += self.mouseAnchor
            self.filteredMouseAnchor *= 0.5
        else:
            ev.ignore()



