/*
* This file is part of MaemoSweeper
*
* Copyright (C) 2005 INdT - Instituto Nokia de Tecnologia
* http://www.indt.org/maemo
*
* This software is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public License
* as published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA
*
*/


#include <stdio.h>
#include <gtk/gtk.h>
#include <startup_plugin.h>
#include <gconf/gconf.h>
#include <gconf/gconf-client.h>

#define SETTINGS_DIFFICULTY "/apps/osso/maemosweeper/difficulty"

static GtkWidget *load_plugin      (void);
static void       unload_plugin    (void);
static void       write_config     (void);
static GtkWidget **load_menu       (guint *);
static void       update_menu      (void);

GConfClient *gcc = NULL;
GtkWidget *board_box;
GtkWidget *board_box_align;

static StartupPluginInfo plugin_info = {
  load_plugin,
  unload_plugin,
  write_config,
  load_menu,
  update_menu,
  NULL
};

static GameStartupInfo gs;
STARTUP_INIT_PLUGIN(plugin_info, gs, TRUE, FALSE)

static GtkWidget **
load_menu (guint *nitems) {
    return NULL;
}

static void 
update_menu (void)
{
    return;
}

static GtkWidget *
load_plugin (void)
{
  int sound, board;
  GtkWidget *game_hbox;
  GtkWidget *board_hbox;
  GtkWidget *board_label;

  g_type_init();
  gcc = gconf_client_get_default();
  board = gconf_client_get_int(gcc, SETTINGS_DIFFICULTY, NULL);

  game_hbox = gtk_hbox_new (TRUE, 0);
  g_assert (game_hbox);

  board_hbox = gtk_hbox_new (FALSE, 8);
  
  board_box = gtk_combo_box_new_text ();

  g_assert (board_box);

  gtk_combo_box_append_text (GTK_COMBO_BOX (board_box),
    "Easy");
  gtk_combo_box_append_text (GTK_COMBO_BOX (board_box),
    "Normal");
  gtk_combo_box_append_text (GTK_COMBO_BOX (board_box),
    "Hard");

  gtk_combo_box_set_active (GTK_COMBO_BOX (board_box), board);

  board_box_align = gtk_alignment_new (0.5, 0.5, 1, 0);
  gtk_widget_set_size_request (board_box, 200, 30);
  gtk_container_add (GTK_CONTAINER (board_box_align), board_box);

  gtk_box_pack_end (GTK_BOX (board_hbox),
    board_box_align, FALSE, FALSE, 0);

  board_label = gtk_label_new ("Difficulty");
  g_assert(board_label);

  gtk_box_pack_end (GTK_BOX (board_hbox),
    board_label, FALSE, FALSE, 0);

  gtk_box_pack_start (GTK_BOX (game_hbox),
    board_hbox, FALSE, FALSE, 2);

  return game_hbox;
}

static void
unload_plugin (void)
{
}

static void 
write_config (void)
{
  gconf_client_set_int(gcc, SETTINGS_DIFFICULTY,
	gtk_combo_box_get_active(GTK_COMBO_BOX(board_box)), NULL);
}


