#ifndef _IMAGES_H_
#define _IMAGES_H_

#include <SDL/SDL.h>

#define PIXMAPSPREFIX "/usr/share/maemosweeper/pixmaps/"

#define BOARD_OFFSETX                    37
#define BOARD_OFFSETY                    73

#define COUNTER_OFFSETX                 711
#define COUNTER_OFFSETY                  25
#define COUNT_NUMBER_SIZEX               22
#define COUNT_NUMBER_SIZEY               33

#define RESTART_OFFSETX                 181
#define RESTART_OFFSETY                  62
#define RESTART_X                       606
#define RESTART_Y                       410

#define CURSORFLAG_X                    208
#define CURSORFLAG_Y                    410
#define CURSORFLAG_OFFSETX              165
#define CURSORFLAG_OFFSETY               55

#define CURSOROPEN_X                     31
#define CURSOROPEN_Y                    410
#define CURSOROPEN_OFFSETX              141
#define CURSOROPEN_OFFSETY               55

#define SCREEN_BOUNDARYX                799
#define SCREEN_BOUNDARYY                479

#define MINE_SIZE                        25

#define DIALOG_SIZEX                    400
#define DIALOG_SIZEY                    100


#define MINES_NUMBER	                  9
#define MINES		                      8

#define BOMBS_NUMBER                     80
#define IS_BOMB                          10
#define NO_NUMBER                         0

#define DIFFICULTY_REDIMENSION_EASY      10
#define DIFFICULTY_REDIMENSION_NORMAL     5
#define DIFFICULTY_REDIMENSION_HARD       0

// the grid/ minefield dimensions
#define COLS                             28
#define ROWS                             12
#define DIMENSION	              COLS*ROWS

//main surface    
extern SDL_Surface *screen;
// gurent processed position
extern int indexX, indexY;

//cell possible states
typedef enum {
    UNREVEALED_CELL = 0, MARKED_CELL,
    QUESTIONMARKED_CELL, HIDDENBOMB_CELL,
    REVEALEDBOMB_CELL, NOTBOMBMARKED_CELL,
    QUESTIONMARKEDDOWN_CELL, UNREVEALEDDOWN_CELL,
    REVEALED_CELL
}CellState;

// current game state
typedef enum {
    WAIT_STATE=0, NEWGAME_STATE, GAMEOVER_STATE, CLEAREDGAME_STATE, STARTEDGAME_STATE
}GameState;

    extern GameState gState;

    extern int sizeX;
    extern int sizeY;

    unsigned char minefield[DIMENSION];

    unsigned char cellstates[DIMENSION];

    int load_surfaces();

    void free_surfaces();

    void draw_background(int marked, int click_type, int difficulty_offset);

    void initialize_grid();

    void statesave(int marking, int marked, int difficulty); 

    int loadstatesaved(int *marked, int *difficulty);

    int check_end_game(void);  

    void show_dialog(int won);
        
    void spread_mines(int bombs, int difficulty_offset);

    void gameOver();
 
    void fill_minenumber();

    void set_flag(int x, int y, int bombs);

    int show_cellcontent(int x, int y);

    void set_cellstate(int x, int y);
    
    int get_cellstate(int x, int y);    

    int count_markedcells(int x, int y);

    void show_cells_around(int x, int y);
    
    int count_minesaround(int x, int y);
    

#endif //_IMAGES_H_
