#ifndef STASHWIDGET_H
#define STASHWIDGET_H

#include <QWidget>
#include <QSize>
#include <QtGui/qpainter.h>
#include <QPushButton>

namespace Ui {
    class StashWidget;
}

class StashWidget : public QWidget
{
    Q_OBJECT

public:
    explicit StashWidget(QWidget *parent = 0);
    ~StashWidget();

private:
    Ui::StashWidget *ui;

private slots:
    void on_btnApplications_clicked();
    void on_btnLinks_clicked();
    void on_btnFolders_clicked();

protected:
    void paintEvent(QPaintEvent *event)
    {
        QPainter p(this);
        p.setBrush(QColor(0, 0, 0, 180));
        p.setPen(Qt::NoPen);
        p.drawRoundedRect(rect(), 12, 12);
        p.end();
        QWidget::paintEvent(event);
    }
};

#endif // STASHWIDGET_H
