#ifndef DIALOG_H
#define DIALOG_H

#include <QDialog>
#include <QListWidgetItem>
#include <QtXml/QDomDocument>
#include <QFile>
#include <QtGui/QLabel>
#include <QDir>
#include <QTextStream>
#include <QDesktopServices>
#include <QUrl>
#include <QtDBus>
#include <QSize>
#include <iostream>
#include <ListDelegate.h>
#include <libintl.h>
#include <locale.h>
#include <QProcess>

namespace Ui {
    class Dialog;
}

class Dialog : public QDialog
{
    Q_OBJECT

public:
    explicit Dialog(QWidget *parent = 0);
    ~Dialog();

private:
    Ui::Dialog *ui;
    int actionType;

public slots:
    void loadData(int);

private slots:
    void on_txtSearch_textChanged();
    void on_btnCloseSearch_clicked();
    void on_btnSort_clicked();
    void on_btnAbout_clicked();
    void on_listWidget_itemClicked(QListWidgetItem* item);
    void on_btnCancel_clicked();
    void loadFolders();
    void loadBookmarks();
    void loadApplications();
    void keyReleaseEvent(QKeyEvent *);
    QString getComment(QString xTextDoamin, QString execPath);
};

#endif // DIALOG_H
