#include "dialog.h"
#include "ui_dialog.h"
#include "dialogabout.h"

Dialog::Dialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::Dialog)
{
    ui->setupUi(this);
    ui->txtSearch->setVisible(false);
    ui->btnCloseSearch->setVisible(false);
}

Dialog::~Dialog()
{
    delete ui;
}

void Dialog::keyReleaseEvent(QKeyEvent* event)
{
    if (event->key() != Qt::Key_Left && event->key() != Qt::Key_Right &&
        event->key() != Qt::Key_Up && event->key() != Qt::Key_Down &&
        event->key() != Qt::Key_Backspace && event->key() != Qt::Key_Return &&
        event->key() != Qt::Key_Control && event->key() != Qt::Key_Shift &&
        event->key() != Qt::Key_Alt && event->key() != Qt::Key_AltGr)
    {
        //ui->listWidget->setMaximumHeight(278);
        ui->txtSearch->insertPlainText(event->text());
        ui->txtSearch->setFocus();
        ui->txtSearch->setVisible(true);
        ui->btnCloseSearch->setVisible(true);
    }
}

QString Dialog::getComment(QString xTextDomain, QString execPath)
{
    //QString retComment = execPath;
    if (xTextDomain == "osso-games" && execPath.toLower().indexOf("chess") > -1)
    {
        xTextDomain = "gnuchess";
    }
    else if (xTextDomain == "osso-games" && execPath.toLower().indexOf("mahjong") > -1)
    {
        xTextDomain = "osso-mahjong";
    }
    else if (xTextDomain == "osso-clock" && execPath.toLower().indexOf("worldclock") > -1)
    {
        xTextDomain = "clock-ui";
    }
    QString retComment = "";
    QStringList execList = execPath.split("/");
    QString execName = execList[execList.length() - 1];
    bool isFound = false;
    QProcess apt;
    apt.start("sh -c \"apt-cache show " + xTextDomain.replace("_", "-") + " | grep 'Description:' | tail -1\"");
    apt.waitForFinished();
    while(apt.canReadLine())
    {
        QString outData = apt.readLine();
        if (outData.startsWith("Description:"))
        {
            //qDebug() << outData;
            QStringList tmpSplit = outData.split(":");
            if (tmpSplit.length() >= 2)
            {
                retComment = tmpSplit[tmpSplit.length() - 1];
                isFound = true;
            }
        }
    }
    apt.close();
    if (!isFound)
    {
        apt.start("sh -c \"apt-cache show " + execName.replace("_", "-") + " | grep 'Description:' | tail -1\"");
        apt.waitForFinished();
        while(apt.canReadLine())
        {
            QString outData = apt.readLine();
            if (outData.startsWith("Description:"))
            {
                //qDebug() << outData;
                QStringList tmpSplit = outData.split(":");
                if (tmpSplit.length() >= 2)
                {
                    retComment = tmpSplit[tmpSplit.length() - 1];
                    isFound = true;
                }
            }
        }
        apt.close();
    }
    if (!isFound && xTextDomain.indexOf("-ui") > -1)
    {
        apt.start("sh -c \"apt-cache show " + xTextDomain.replace("_", "-").replace("-ui", "") + " | grep 'Description:' | tail -1\"");
        apt.waitForFinished();
        while(apt.canReadLine())
        {
            QString outData = apt.readLine();
            if (outData.startsWith("Description:"))
            {
                //qDebug() << outData;
                QStringList tmpSplit = outData.split(":");
                if (tmpSplit.length() >= 2)
                {
                    retComment = tmpSplit[tmpSplit.length() - 1];
                    isFound = true;
                }
            }
        }
        apt.close();
    }
    //qDebug() << xTextDomain << " / " << execName << " = " << retComment;
    return retComment.replace("OSSO ", "").trimmed();
}

void Dialog::on_btnCancel_clicked()
{
    this->close();
}

void Dialog::loadData(int tyyppi)
{
    actionType = tyyppi;
    switch(tyyppi)
    {
    case 0:
        loadFolders();
        break;
    case 1:
        loadBookmarks();
        break;
    case 2:
        loadApplications();
        break;
    default:
        break;
    }
}

void Dialog::loadFolders()
{
    QString searchDir = "/home/user/MyDocs/";
    QDir dir = QDir(searchDir);
    dir.setFilter(QDir::Dirs | QDir::AllDirs | QDir::NoDotAndDotDot | QDir::Hidden);
    //dir.setSorting(QDir::Name);
    QString name;
    QString realName;
    QString iconStr = "general_folder";
    QFileInfoList list = dir.entryInfoList();
    for (int i = 0; i < list.size(); ++i) {
        QFileInfo fileInfo = list.at(i);
        name = fileInfo.fileName();
        realName = name;
        if (name == ".documents")
        {
            name = "sfil_li_folder_documents";
            iconStr = "filemanager_document_folder";
        }
        else if (name == ".sounds")
        {
            name = "sfil_li_folder_sound_clips";
            iconStr = "filemanager_audio_folder";
        }
        else if (name == ".videos")
        {
            name = "sfil_li_folder_video_clips";
            iconStr = "filemanager_video_folder";
        }
        else if (name == ".images")
        {
            name = "sfil_li_folder_images";
            iconStr = "filemanager_image_folder";
        }
        else if (name == "DCIM")
        {
            name = "sfil_li_folder_camera";
            iconStr = "filemanager_camera_folder";
        }
        else if (name == ".games")
        {
            name = "sfil_li_folder_games";
            iconStr = "filemanager_games_folder";
        }
        else
        {
            iconStr = "general_folder";
        }
        if (!name.startsWith(".") && name != "Mac OS")
        {
            QString searchPath = fileInfo.filePath();
            QDir searchDir = QDir(searchPath);
            searchDir.setFilter(QDir::Dirs | QDir::Files | QDir::NoDotAndDotDot);
            QFileInfoList searchList = searchDir.entryInfoList();
            int fileCount = 0;
            int dirCount = 0;
            for (int j = 0; j < searchList.size(); ++j)
            {
                QFileInfo searchFileInfo = searchList.at(j);
                if (searchFileInfo.isDir())
                {
                    dirCount ++;
                }
                if (searchFileInfo.isFile())
                {
                    fileCount ++;
                }
            }
            realName = QString::fromUtf8(dgettext("hildon-fm", name.toLatin1()));
            ui->listWidget->setItemDelegate(new ListDelegate(ui->listWidget));
            QListWidgetItem *item = new QListWidgetItem();
            item->setData(Qt::DecorationRole, QIcon::fromTheme(iconStr, QIcon(":/images/general_folder.png")));
            item->setData(Qt::DisplayRole, realName);
            item->setData(Qt::UserRole, QVariant(fileInfo.filePath().toLatin1().replace(" ", "\\ ")));
            item->setData(Qt::UserRole + 1, QVariant(QString("%1").arg(dirCount) + (dirCount == 1 ? " directory, " : " directories, ") + QString("%1").arg(fileCount) + (fileCount == 1 ? " file" : " files")));
            item->setData(Qt::WhatsThisRole, QVariant(0));
            ui->listWidget->addItem(item);
        }
    }
    ui->listWidget->sortItems(Qt::AscendingOrder);
    ui->btnSort->setText("Sort DESC");
//    ui->listWidget->viewport()->installEventFilter(this);
}

void Dialog::loadBookmarks()
{
    QString iconDir = "/home/user/.bookmarks/thumbnails/";
    QDomDocument doc("xbel");
    QFile file("/home/user/.bookmarks/MyBookmarks.xml");
    if (!file.open(QIODevice::ReadOnly))
    {
        qDebug("--> loadBookmarks: Could not open file!!!");
        return;
    }
    if (!doc.setContent(&file))
    {
        qDebug("--> loadBookmarks: Could not set content!!!");
        file.close();
        return;
    }
    file.close();
    QDomElement root = doc.documentElement();
    if(root.tagName() != "xbel")
    {
        qDebug("--> loadBookmarks: Root not xbel!!!");
        return;
    }
    QDomNode n = root.firstChild();
    while(!n.isNull())
    {
        QDomElement bookmarkElem = n.toElement();
        if (!bookmarkElem.isNull())
        {
            if (bookmarkElem.tagName() == "bookmark")
            {
                QString href = bookmarkElem.attribute("href", "");
                QString thumbnail = bookmarkElem.attribute("thumbnail", "");
                QDomElement titleElem = bookmarkElem.firstChildElement("title");
                QDomElement infoElem = bookmarkElem.firstChildElement("info");
                QDomElement metaDataElem = infoElem.firstChildElement("metadata");
                QDomElement deletedElem = metaDataElem.firstChildElement("deleted");
                if (!titleElem.isNull() && deletedElem.text() != "1")
                {
                    QString title = titleElem.text();
                    ui->listWidget->setItemDelegate(new ListDelegate(ui->listWidget));
                    QListWidgetItem *item = new QListWidgetItem();
                    item->setData(Qt::DecorationRole, QIcon(iconDir + thumbnail));
                    item->setData(Qt::DisplayRole, title);
                    item->setData(Qt::UserRole, QVariant(href));
                    item->setData(Qt::UserRole + 1, QVariant(href));
                    item->setData(Qt::WhatsThisRole, QVariant(1));
                    ui->listWidget->addItem(item);

                }

            }
            else if (bookmarkElem.tagName() == "folder")
            {
                QDomElement inFolderBookmarkElem = bookmarkElem.firstChildElement("bookmark");
                QString href = inFolderBookmarkElem.attribute("href", "");
                QString thumbnail = inFolderBookmarkElem.attribute("thumbnail", "");
                QDomElement titleElem = inFolderBookmarkElem.firstChildElement("title");
                QDomElement infoElem = inFolderBookmarkElem.firstChildElement("info");
                QDomElement metaDataElem = infoElem.firstChildElement("metadata");
                QDomElement deletedElem = metaDataElem.firstChildElement("deleted");
                if (!titleElem.isNull() && deletedElem.text() != "1")
                {
                    QString title = titleElem.text();
                    ui->listWidget->setItemDelegate(new ListDelegate(ui->listWidget));
                    QListWidgetItem *item = new QListWidgetItem();
                    item->setData(Qt::DecorationRole, QIcon(iconDir + thumbnail));
                    item->setData(Qt::DisplayRole, title);
                    item->setData(Qt::UserRole, QVariant(href));
                    item->setData(Qt::UserRole + 1, QVariant(href));
                    item->setData(Qt::WhatsThisRole, QVariant(1));
                    ui->listWidget->addItem(item);

                }

            }
        }
        n = n.nextSibling();
    }
    ui->listWidget->sortItems(Qt::AscendingOrder);
    ui->btnSort->setText("Sort DESC");
}

void Dialog::loadApplications()
{
    QDirIterator iter("/usr/share/applications/hildon/");
    while(iter.hasNext())
    {
        QString path = iter.next();
        //qDebug() << path;
        if(path.endsWith(".desktop"))
        {
            QSettings settings(path, QSettings::IniFormat);
            settings.beginGroup("Desktop Entry");
            QString name = settings.value("Name", "No Name").toString();
            QString comment = settings.value("Comment", "").toString();
            QString icon;
            QString exec = path.section("/", 5, 5).replace(".desktop", "");
            //qDebug() << "exec = " + exec;
            QString execPath;
            QString type;
            QString domain("maemo-af-desktop");
            bool isApp = false;
            if(settings.contains("X-Text-Domain"))
            {
                domain = settings.value("X-Text-Domain").toString();
            }
            name = QString::fromUtf8(dgettext(domain.toLatin1(), name.toLatin1()));
            if (settings.contains("Icon"))
            {
                icon = settings.value("Icon").toString();
            }
            if (settings.contains("Exec"))
            {
                execPath = settings.value("Exec").toString();
            }
            if (settings.contains("Type"))
            {
                type = settings.value("Type").toString();
                isApp = type.toLower().startsWith("application");
            }
            if(settings.contains("Comment"))
            {
                comment = QString::fromUtf8(dgettext(domain.toLatin1(), settings.value("Comment").toString().toLatin1()));
            }
//            if (comment.indexOf("_") > -1 || comment == "No Comment")
//            {
//                comment = getComment(domain, execPath);
//            }
            if (isApp)
            {
                ui->listWidget->setItemDelegate(new ListDelegate(ui->listWidget));
                QListWidgetItem *item = new QListWidgetItem();
                QIcon appIcon = QIcon::fromTheme(icon, QIcon(":/images/general_applications.png"));
                item->setData(Qt::DecorationRole, appIcon);
                item->setData(Qt::DisplayRole, name);
                item->setData(Qt::UserRole, QVariant(exec));
                item->setData(Qt::UserRole + 1, QVariant(comment.indexOf("_") > -1 || comment == "" ? execPath : comment));
                //item->setData(Qt::UserRole + 1, QVariant(comment));
                item->setData(Qt::WhatsThisRole, QVariant(2));
                ui->listWidget->addItem(item);
            }
        }
    }
    ui->listWidget->sortItems(Qt::AscendingOrder);
    ui->btnSort->setText("Sort DESC");
}

void Dialog::on_listWidget_itemClicked(QListWidgetItem* item)
{
    int actionType = qvariant_cast<int>(item->data(Qt::WhatsThisRole));
    switch(actionType)
    {
    case 0:
        {
            QDBusInterface browserd("com.nokia.osso_filemanager",
                                    "/com/nokia/osso_filemanager",
                                    "com.nokia.osso_filemanager");
            browserd.call("open_folder", item->data(Qt::UserRole).toString());
            break;
        }
    case 1:
        {
            QDBusInterface browserd("com.nokia.osso_browser",
                                    "/com/nokia/osso_browser/request",
                                    "com.nokia.osso_browser");
            browserd.call("open_new_window", item->data(Qt::UserRole).toString());
            break;
        }
    case 2:
        {
            // dbus-send --session --dest=com.nokia.HildonDesktop.AppMgr
            // --type=method_call
            // /com/nokia/HildonDesktop/AppMgr
            // com.nokia.HildonDesktop.AppMgr.LaunchApplication string:MyApp

            QDBusInterface browserd("com.nokia.HildonDesktop.AppMgr",
                                    "/com/nokia/HildonDesktop/AppMgr",
                                    "com.nokia.HildonDesktop.AppMgr");
            browserd.call("LaunchApplication", item->data(Qt::UserRole).toString());
            break;
        }
    }
    this->close();
}

void Dialog::on_btnAbout_clicked()
{
    DialogAbout *aboutDialog = new DialogAbout();
    aboutDialog ->setWindowTitle("About Shortcut Stash");
    aboutDialog ->show();
}

void Dialog::on_btnSort_clicked()
{
    ui->listWidget->sortItems((ui->btnSort->text() == "Sort ASC" ? Qt::AscendingOrder : Qt::DescendingOrder));
    ui->btnSort->setText((ui->btnSort->text() == "Sort ASC" ? "Sort DESC" : "Sort ASC"));
}

void Dialog::on_btnCloseSearch_clicked()
{
    ui->txtSearch->setPlainText("");
    ui->txtSearch->setVisible(false);
    ui->btnCloseSearch->setVisible(false);
    for (int i = 0; i < ui->listWidget->count(); i ++)
    {
        QListWidgetItem *item = ui->listWidget->item(i);
        ui->listWidget->setItemHidden(item, false);
    }
    //ui->listWidget->setMaximumHeight(16777215);
}

void Dialog::on_txtSearch_textChanged()
{
    if (ui->txtSearch->toPlainText() == "")
    {
        for (int i = 0; i < ui->listWidget->count(); i ++)
        {
            QListWidgetItem *item = ui->listWidget->item(i);
            ui->listWidget->setItemHidden(item, false);
        }
    }
    else
    {
        for (int i = 0; i < ui->listWidget->count(); i ++)
        {
            QListWidgetItem *item = ui->listWidget->item(i);
            QString data = item->data(Qt::DisplayRole).toString();
            if (data.contains(ui->txtSearch->toPlainText(), Qt::CaseInsensitive))
            {
                ui->listWidget->setItemHidden(item, false);
            }
            else
            {
                ui->listWidget->setItemHidden(item, true);
            }
        }
    }
}

//void QPlainTextEdit::keyReleaseEvent(QKeyEvent *event)
//{
//    //QPlainTextEdit::setPlainText(QPlainTextEdit::toPlainText().trimmed());
//    if (event->key() != Qt::Key_Return && event->key() != Qt::Key_Enter)
//    {
//        qDebug() << "--> QPlainTextEdit::keyReleaseEvent: " << event->key();
//        //return QPlainTextEdit::keyReleaseEvent(event);
//    }
//}
