#include "ListDelegate.h"

ListDelegate::ListDelegate(QObject *parent)
{

}

void ListDelegate::paint (QPainter * painter, const QStyleOptionViewItem & option, const QModelIndex & index) const {
    QRect r = option.rect;

    // Color: #C4C4C4
    QPen linePen(QColor::fromRgb(0, 36, 57), 0.1, Qt::SolidLine);

    // Color: #005A83
    QPen lineMarkedPen(QColor::fromRgb(70, 130, 180), 0.1, Qt::SolidLine);

    // Color: #333
    QPen fontPen(QColor::fromRgb(255, 255, 255), 1, Qt::SolidLine);

    QPen fontDescriptionPen(Qt::gray, 1, Qt::SolidLine);

    // Color: #fff
    QPen fontMarkedPen(Qt::white, 1, Qt::SolidLine);

    if(option.state & QStyle::State_Selected)
    {
        QLinearGradient gradientSelected(r.left(), r.top(), r.left(), r.height() + r.top());
        gradientSelected.setColorAt(0.0, QColor::fromRgb(119, 213, 247));
        gradientSelected.setColorAt(0.9, QColor::fromRgb(27, 134, 183));
        gradientSelected.setColorAt(1.0, QColor::fromRgb(0, 120, 174));
        painter->setBrush(gradientSelected);
        painter->drawRect(r);

        //Paint border
        painter->setPen(lineMarkedPen);
        painter->drawLine(r.topLeft(),r.topRight());
        painter->drawLine(r.topRight(),r.bottomRight());
        painter->drawLine(r.bottomLeft(), r.bottomRight());
        painter->drawLine(r.topLeft(),r.bottomLeft());

        painter->setPen(fontMarkedPen);

    }
    else
    {
        // Background
//        painter->setBrush(Qt::black);
//        painter->drawRect(r);

        // Border
        painter->setPen(linePen);
//        painter->drawLine(r.topLeft(),r.topRight());
//        painter->drawLine(r.topRight(),r.bottomRight());
        painter->drawLine(r.bottomLeft(), r.bottomRight());
//        painter->drawLine(r.topLeft(),r.bottomLeft());

        painter->setPen(fontPen);
    }

    // Get title, description and icon
//    QIcon ic = QIcon(qvariant_cast<QPixmap>(index.data(Qt::DecorationRole)));
    QIcon ic = qvariant_cast<QIcon>(index.data(Qt::DecorationRole));
    QString title = index.data(Qt::DisplayRole).toString();
    QString description = index.data(Qt::UserRole + 1).toString();
    int type = qvariant_cast<int>(index.data(Qt::WhatsThisRole).toString());
    int imageSpace = 10;
    if (!ic.isNull())
    {
        if (type == 1)
        {
            // Link Icon
            r = option.rect.adjusted(2, 5, -5, -5);
            ic.paint(painter, r, Qt::AlignVCenter|Qt::AlignLeft);
            imageSpace = 96;
        }
        else
        {
            // App and Dir Icon
            r = option.rect.adjusted(2, 3, -3, -3);
            //ic.paint(painter, r, Qt::AlignVCenter|Qt::AlignLeft);
            ic.paint(painter,r.left(), r.top(), 48, 48, Qt::AlignVCenter|Qt::AlignLeft);
            imageSpace = 64;
        }
    }

    // Paint title
    painter->setPen(fontPen);
    r = option.rect.adjusted(imageSpace, 0, -10, -30);
    painter->setFont(QFont("Arial", 18, QFont::Bold));
    painter->drawText(r.left(), r.top(), r.width(), r.height(), Qt::AlignBottom|Qt::AlignLeft, title, &r);

    //Paint description
    painter->setPen(fontDescriptionPen);
    r = option.rect.adjusted(imageSpace, 30, -10, 0);
    painter->setFont(QFont("Arial", 14, QFont::Normal));
    painter->drawText(r.left(), r.top(), r.width(), r.height(), Qt::AlignLeft, description, &r);
}

QSize ListDelegate::sizeHint (const QStyleOptionViewItem & option, const QModelIndex & index) const {
    return QSize(60, 60); // very dumb value
}

ListDelegate::~ListDelegate()
{

}
