#!/usr/bin/python
# -*- coding: utf-8 -*-

import pygame
from pygame.locals import *
from random import choice
import time

class ColorMatchGame(object):
    def __init__(self, reactor):
        self.reactor = reactor
        # Game specific properties        
        self.colors = [[(255,0,0), "Red"],
                      [(0,255,0), "Green"],
                      [(0,0,255), "Blue"],
                      [(255,255,0), "Yellow"],
                      [(0,255,255), "Cyan"],
                      [(255,0,255), "Pink"],
                      [(160,0,255), "Purple"],
                      [(255,120,0), "Orange"],
                      [(100,60,20), "Brown"]]
        self.step = 0
        self.colorArea = Rect(190, 40,
                      self.reactor.screen.get_width()-380,
                      self.reactor.screen.get_height()-80)
        # Universal Properties
        self.task = "The color name matches the background color"
        
    def play(self):
        if self.step == 0:
            self.step = 45
            self.reactor.clearPlayArea()
            self.currentColor = choice(self.colors)
            choices = []
            for i in range(0,3):
                choices.append (choice(self.colors)[1])
            choices.append(self.currentColor[1])
            self.currentColorName = choice(choices)
            pygame.draw.rect(self.reactor.screen, self.currentColor[0],
                             self.colorArea)
            self.reactor.drawMainText(self.currentColorName, (0,0,0))
        else:
            self.step = self.step - 1
    
    def evaluate(self, player):
        if not self.currentColor[1] == self.currentColorName:
            self.winMessage = "You win!"
            self.loseMessage = "Those don't match!"
            if player == 1: return 2
            if player == 2: return 1
        else:
            self.winMessage = "Well combined!"
            self.loseMessage = "You missed it!"
            if player == 1: return 1
            if player == 2: return 2
