#!/usr/bin/python
# -*- coding: utf-8 -*-

import pygame
from pygame.locals import *
from random import choice
import time

class CrashGame(object):
    def __init__(self, reactor):
        self.reactor = reactor
        # Game specific properties       
        w = self.reactor.screen.get_width()-380
        h = self.reactor.screen.get_height()/3
        self.center = self.reactor.screen.get_width()/2-37
        self.coverBlock = Rect(190, h, w, h)
        self.step = 0
        self.pos1 = (self.center, 40)
        self.pos2 = (self.center, self.reactor.screen.get_height()-75-40)
        speeds = [1,2,3,4,5]
        self.currentSpeed = choice(speeds)
        self.gem1, r1 = self.reactor.load_image('gem05.png', -1)
        self.gem2, r2 = self.reactor.load_image('gem07.png', -1)
        self.gem1 = pygame.transform.scale(
                           self.gem1, (75, 75))
        self.gem2 = pygame.transform.scale(
                           self.gem2, (75, 75))
        # Universal Properties
        self.task = "The two gems are colliding"
    
    def play(self):
        self.reactor.clearPlayArea()
        # draw two circles
        self.pos1 = (self.center, self.pos1[1] + self.currentSpeed)
        self.pos2 = (self.center, self.pos2[1] - self.currentSpeed)
        self.reactor.screen.blit(self.gem1, self.pos1)
        self.reactor.screen.blit(self.gem2, self.pos2)
        # draw a cover block
        pygame.draw.rect(self.reactor.screen, (40,40,40),
                         self.coverBlock)
    
    def evaluate(self, player):
        diff = (self.pos2[1] - (self.pos1[1] + 57))
        print diff
        if diff > 0:
            self.winMessage = "Steady..."
            self.loseMessage = "%d pixels to go!" % diff
            if player == 1: return 2
            if player == 2: return 1
        else:
            self.winMessage = "Well tracked!"
            self.loseMessage = "%d pixels too late!"  % (diff*-1)
            if player == 1: return 1
            if player == 2: return 2
