#-------------------------------------------------------------------------------
# imports
#-------------------------------------------------------------------------------
import sys, os
from PyQt4 import QtCore, QtGui, QtSql


#-------------------------------------------------------------------------------
# enum
#-------------------------------------------------------------------------------
COLOR_ID, NAME, DESCRIPTION = range(3)


#-------------------------------------------------------------------------------
# schema
#-------------------------------------------------------------------------------
def createFakeData():

	query       = QtSql.QSqlQuery()

	print "Dropping table..."
	query.exec_("DROP TABLE color")

	print "Creating table..."
	query.exec_("""CREATE TABLE color (
				color_id PRIMARY KEY,
				name VARCHAR(32) UNIQUE NOT NULL,
				description TEXT NOT NULL)""")


	print "Populating table..."
	query.exec_("INSERT INTO color (name, description) "
				"VALUES ('red', 'this is red')")

	query.exec_("INSERT INTO color (name, description) "
				"VALUES ('vermillion', 'this is vermillion')")

	query.exec_("INSERT INTO color (name, description) "
				"VALUES ('rose madder', 'this is rose madder')")

	query.exec_("INSERT INTO color (name, description) "
				"VALUES ('green', 'this is green')")

	query.exec_("INSERT INTO color (name, description) "
				"VALUES ('phthalocyanine', 'this is phthalocyanine')")

	query.exec_("INSERT INTO color (name, description) "
				"VALUES ('leaf', 'this is leaf')")

	query.exec_("INSERT INTO color (name, description) "
				"VALUES ('blue', 'this is blue')")

	query.exec_("INSERT INTO color (name, description) "
				"VALUES ('ultramarine', 'this is ultramarine')")

	query.exec_("INSERT INTO color (name, description) "
				"VALUES ('cerulean', 'this is cerulean')")





#-------------------------------------------------------------------------------
# class
#-------------------------------------------------------------------------------
class QueryTestForm(QtGui.QWidget):
	def __init__(self, parent=None):
		QtGui.QWidget.__init__(self)


		# table model
		# ------------------------------------------------
		self.theModel = QtSql.QSqlTableModel(self)
		self.theModel.setTable("color")
		self.theModel.setSort(NAME, QtCore.Qt.AscendingOrder)
		self.theModel.setEditStrategy(QtSql.QSqlTableModel.OnManualSubmit)

		# column headers
		self.theModel.setHeaderData(COLOR_ID, QtCore.Qt.Horizontal, QtCore.QVariant("COLOR_ID"))
		self.theModel.setHeaderData(NAME, QtCore.Qt.Horizontal, QtCore.QVariant("NAME"))
		self.theModel.setHeaderData(DESCRIPTION, QtCore.Qt.Horizontal, QtCore.QVariant("DESCRIPTION"))

		select = self.theModel.select()
		print "queryTestForm select: ", select


		# table view
		# ------------------------------------------------
		self.theView = QtGui.QTableView()
		self.theView.setModel(self.theModel)
		self.theView.setSelectionMode(QtGui.QTableView.SingleSelection)
		self.theView.setSelectionBehavior(QtGui.QTableView.SelectRows)
		self.theView.setColumnHidden(COLOR_ID, True)
		self.theView.resizeColumnsToContents()
		self.theView.horizontalHeader().setStretchLastSection(True)


		# table layout
		# ------------------------------------------------
		self.tableLayout		= QtGui.QVBoxLayout()
		self.tableLayout.addWidget(self.theView)
		self.setLayout(self.tableLayout)


		# table view selection model
		# ------------------------------------------------
		self.theSelectionModel = self.theView.selectionModel()


		# signals/slots
		# ------------------------------------------------
		self.connect(self.theSelectionModel,
                     QtCore.SIGNAL("selectionChanged(QItemSelection, QItemSelection)"),
                     self.getSelection)



	# methods
	# ------------------------------------------------
	def getSelection(self, selected, deselected):
		print "getSelection() ..."

		index = self.theSelectionModel.currentIndex()
		print "index: ", index





#-------------------------------------------------------------------------------
# main
#-------------------------------------------------------------------------------
if __name__ == "__main__":
	app = QtGui.QApplication(sys.argv)

	print "Qt Version: ", QtCore.QT_VERSION_STR
	print "PyQt Version: ", QtCore.PYQT_VERSION_STR

	filename = os.path.join(os.path.dirname(__file__), "test.db")
	create = not QtCore.QFile.exists(filename)
	db = QtSql.QSqlDatabase.addDatabase("QSQLITE")
	db.setDatabaseName(filename)

	if not db.open():
		QtGui.QMessageBox.warning(None, "Test",
			QtCore.QString("Database Error: %1").arg(db.lastError().text()))
		sys.exit(1)

	ok		  = db.open()
	print "db connection:	", ok

	createFakeData()
	form = QueryTestForm()
	form.setWindowTitle("Selection Model Test")
	form.show()
	sys.exit(app.exec_())