
/* Copyright: (c) 2005-2009 Nokia Corporation
 *
 * The code examples copyrighted by Nokia Corporation that are included to
 * this material are licensed to you under following MIT-style License:
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "examplewindow.h"
#include <iostream>

static Glib::RefPtr<Gdk::Pixbuf> load_image(const std::string& filename)
{
  Glib::RefPtr<Gdk::Pixbuf> result;

  std::auto_ptr<Glib::Error> ex;
  result = Gdk::Pixbuf::create_from_file("images/" + filename, 
    64, 64, true, ex);
  
  if(ex.get())
  {
    std::cerr << "Error while loading file: " << ex->what() << std::endl;
  }

  return result;
}

ExampleWindow::ExampleWindow() :
  pickerbutton_(Gtk::Hildon::SIZE_HALFSCREEN_WIDTH |
    Gtk::Hildon::SIZE_FINGER_HEIGHT, Hildon::BUTTON_ARRANGEMENT_VERTICAL)
{
  set_title("Hildon::TouchSelector Example");

  // Create TreeModels and add TouchSelectorColumns to show them:
  Glib::RefPtr<Gtk::ListStore> list_store = 
    Gtk::ListStore::create(people_columns_);
  Glib::RefPtr<Hildon::TouchSelectorColumn> name_column =
    touchselector_.append_text_column(list_store);
  name_column->set_property("text-column", 0); // TODO: Add a TextSelectorColumn::set_text_column() method?

  name_column->pack_start(people_columns_.surname_, false);
  name_column->pack_start(people_columns_.picture_);

  // Populate the TreeModel with data:
  Gtk::TreeModel::Row row = *(list_store->append());
  row[people_columns_.name_] = "Armin";
  row[people_columns_.surname_] = "Burgmeier";
  row[people_columns_.picture_] = load_image("armin_burgmeier.png");
  row = *(list_store->append());
  row[people_columns_.name_] = "Daniel";
  row[people_columns_.surname_] = "Borgmann";
  row[people_columns_.picture_] = load_image("daniel_borgmann.png");
  row = *(list_store->append());
  row[people_columns_.name_] = "Daniel";
  row[people_columns_.surname_] = "Elstner";
  row[people_columns_.picture_] = load_image("daniel_elstner.png");
  row = *(list_store->append());
  row[people_columns_.name_] = "David";
  row[people_columns_.surname_] = "King";
  row[people_columns_.picture_] = load_image("david_king.png");
  row = *(list_store->append());
  row[people_columns_.name_] = "Jan Arne";
  row[people_columns_.surname_] = "Petersen";
  row[people_columns_.picture_] = load_image("jan_arne_petersen.png");
  row = *(list_store->append());
  row[people_columns_.name_] = "Mathias";
  row[people_columns_.surname_] = "Hasselmann";
  row[people_columns_.picture_] = load_image("mathias_hasselmann.png");
  row = *(list_store->append());
  row[people_columns_.name_] = "Michael";
  row[people_columns_.surname_] = "Hasselmann";
  row[people_columns_.picture_] = load_image("michael_hasselmann.png");
  row = *(list_store->append());
  row[people_columns_.name_] = "Murray";
  row[people_columns_.surname_] = "Cumming";
  row[people_columns_.picture_] = load_image("murrayc.png");

  
  pickerbutton_.set_selector(touchselector_);
  pickerbutton_.set_title("Select a Name");

  box_.add(pickerbutton_);
  add(box_);

  pickerbutton_.signal_value_changed().connect(
    sigc::mem_fun(*this, &ExampleWindow::on_value_changed));

  //Set a callback function to build a text representation of the 
  //selected item for the picker button:
  touchselector_.set_print_func(
    sigc::mem_fun(*this, &ExampleWindow::picker_button_print_func));

  show_all_children();
}

ExampleWindow::~ExampleWindow()
{
}

void ExampleWindow::on_value_changed()
{
  std::cout << "Selection changed. Current state=" <<
    touchselector_.get_current_text() << std::endl;
}

// Combine strings in TouchSelector, adding space between each string.
Glib::ustring ExampleWindow::picker_button_print_func()
{
  Gtk::TreeModel::iterator iter = touchselector_.get_selected(0);
  Gtk::TreeModel::Row row = *iter;
  Glib::ustring name = row[people_columns_.name_];
  Glib::ustring surname = row[people_columns_.surname_];
  
  return name + " " + surname;
}
