
/* Copyright: (c) 2005-2009 Nokia Corporation
 *
 * The code examples copyrighted by Nokia Corporation that are included to
 * this material are licensed to you under following MIT-style License:
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "examplewizard.h"
#include <hildonmm/button.h>

ExampleWizard::ExampleWizard() :
  Hildon::WizardDialog("Example wizard"),
  vbox_pageone_(false, 6),
  label_("Example text for page one"),
  vbox_pagetwo_(false, 6),
  checkbutton_(Gtk::Hildon::SIZE_HALFSCREEN_WIDTH |
    Gtk::Hildon::SIZE_FINGER_HEIGHT)
{
  checkbutton_.set_label("Example checkbutton for page two");
  vbox_pageone_.pack_start(label_, Gtk::PACK_SHRINK);
  vbox_pagetwo_.pack_start(checkbutton_, Gtk::PACK_SHRINK);

  notebook_.append_page(vbox_pageone_);
  notebook_.append_page(vbox_pagetwo_);
  notebook_.show_all_children();

  set_wizard_notebook(notebook_);
  show_all_children();
}

ExampleWizard::~ExampleWizard()
{
}
