
/* Copyright: (c) 2005-2009 Nokia Corporation
 *
 * The code examples copyrighted by Nokia Corporation that are included to
 * this material are licensed to you under following MIT-style License:
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "examplewindow.h"
#include <gtkmm.h>
#include <iostream>

ExampleWindow::ExampleWindow() :
  find_toolbar_("Find String: "),
  tool_new_(Gtk::Stock::NEW),
  tool_open_(Gtk::Stock::OPEN),
  tool_save_(Gtk::Stock::SAVE),
  tool_close_(Gtk::Stock::CLOSE),
  tool_find_(Gtk::Stock::FIND),
  item_others_("Others"),
  item_radio1_(group_, "Radio1"),
  item_radio2_(group_, "Radio2"),  
  item_check_("Check"),
  item_close_("Close")
{
  set_title("Hildon::FindToolbar Example");
  // Create Combobox on tool item.
  Gtk::ComboBoxText* combo = Gtk::manage(new Gtk::ComboBoxText);
  combo->append_text("Entry 1");
  combo->append_text("Entry 2");
  combo->append_text("Entry 3");	
  combo->set_active(1);
  tool_combo_.set_expand();
  tool_combo_.add(*combo);
  
  // Add toolbar items to toolbar.
  main_toolbar_.append(tool_new_);
  main_toolbar_.append(tool_separator_);
  main_toolbar_.append(tool_open_);
  main_toolbar_.append(tool_save_);
  main_toolbar_.append(tool_combo_);
  main_toolbar_.append(tool_find_);
  main_toolbar_.append(tool_close_);
  main_toolbar_.show_all();
  
  // Attach the callback functions to the activate signal.
  tool_close_.signal_clicked().connect(
    sigc::mem_fun(*this, &ExampleWindow::on_item_close));
  
  // Attach find toolbar callbacks.
  find_toolbar_.signal_close().connect(
    sigc::mem_fun(*this, &ExampleWindow::on_find_toolbar_close));
  find_toolbar_.signal_search().connect(
    sigc::mem_fun(*this, &ExampleWindow::on_find_toolbar_search));	
  tool_find_.signal_clicked().connect(
    sigc::mem_fun(*this, &ExampleWindow::on_find_toolbar_close));
  
  // Attach find toolbar.
  add_toolbar(main_toolbar_);
  add_toolbar(find_toolbar_);
  
  // Add menu items to right menus.
  main_.append(item_others_);
  sub_others_.append(item_radio1_);
  sub_others_.append(item_radio2_);
  sub_others_.append(item_separator_);
  sub_others_.append(item_check_);
  main_.append(item_close_);
  
  // Add others submenu to the "Others" item.
  item_others_.set_submenu(sub_others_);
  main_.show_all(); // Show the menu and all its child widgets.
  set_main_menu(main_);

  // Attach the callback functions to the activate signal.
  item_close_.signal_activate().connect(
    sigc::mem_fun(*this, &ExampleWindow::on_item_close));
  
  show_all_children();
  find_toolbar_.hide();
  
  find_visible_ = false;
}

ExampleWindow::~ExampleWindow()
{
}

void ExampleWindow::on_item_close()
{
  hide();
}

void ExampleWindow::on_find_toolbar_close()
{
  // Show or hide find toolbar.
  if(find_visible_)
  {
    find_toolbar_.hide();
    find_visible_ = false;
  }
  else
  {
    find_toolbar_.show();
    find_visible_ = true;
  }
}

void ExampleWindow::on_find_toolbar_search()
{
  // TODO: This code does not work.
  Glib::ustring prefix;
  find_toolbar_.get_property("prefix", prefix);
  std::cout << "Search for: " << prefix << std::endl;
}
